package com.netcore.android.logger

import android.util.Log

/**
 * Copyright © 2019 Netcore. All rights reserved.
 *
 * Log Printer class which calls Android default Log internally
 * to print logs in the Android Studio console
 *
 * @author Netcore
 * @version 1.0
 * @since 26-02-2019
 */
internal class SMTLoggerPrinter : SMTPrinter {

    override fun internal(tag: String, message: String) {
        Log.i(tag, message)
    }

    override fun d(tag: String, message: String) {
        Log.d(tag, message)
    }

    override fun e(tag: String, message: String) {
        Log.e(tag, message)
    }

    override fun w(tag: String, message: String) {
        Log.w(tag, message)
    }

    override fun i(tag: String, message: String) {
        Log.i(tag, message)
    }

    override fun v(tag: String, message: String) {
        Log.v(tag, message)
    }


}