package com.netcore.android.inbox.views.activity

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.netcore.android.R
import com.netcore.android.inbox.views.fragment.SMTInboxFragment

/**
 * Activity to hold inbox fragment
 * It is used to show app inbox view
 *
 * @author Netcore
 * @version 1.0
 * @since 01-05-2019
 */
internal class InBoxActivity : AppCompatActivity() {


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        // set the layout
        setContentView(R.layout.inbox_activity)

        // add the inbox fragment to the view
        addInBoxFragment()
    }

    /**
     * Adds the inbox fragment to fragment container of the activity
     */
    private fun addInBoxFragment() {
        val inboxFragment = SMTInboxFragment()
        supportFragmentManager.beginTransaction().add(R.id.inapp_fragment_container, inboxFragment, "InBox").commitAllowingStateLoss()
    }
}