package com.netcore.android.inbox.utility;

import androidx.annotation.IntDef;
import androidx.annotation.Keep;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;


public class SMTInboxMessageStatus {

    @Keep
    @IntDef({Status.VIEWED, Status.READ, Status.DELETED, Status.DELIVERED})
    @Retention(RetentionPolicy.SOURCE)
    public @interface Status {
        int DELIVERED = 1; // when message fetched
        int VIEWED = 2; // when message displayed in screen
        int READ = 3; // when message clicked by user
        int DELETED = 4; // when user deletes the message
    }
}
