package com.netcore.android.preference

/**
 * It is an interface implemented by the AppPreferenceHelper
 * and contains methods exposed to the application components.
 * This layer decouples any specific implementation of the PreferenceHelper
 * and hence makes AppPreferenceHelper as plug and play unit.
 *
 * @author Netcore
 * @version 1.0
 * @since 26-02-2019
 */
internal interface SMTPreferenceInterface {

    fun getDouble(key: String): Double
    fun getLong(key: String): Long
    fun setDouble(key: String, value: Double)
    fun setInt(key: String, value: Int)
    fun getInt(key: String): Int
    fun getInt(key:String,defaultValue:Int):Int
    fun setBoolean(key: String, value: Boolean)
    fun getBoolean(key: String): Boolean
    fun setString(key: String, value: String)
    fun getString(key: String): String
    fun getString(key: String, value: String): String
//    fun getObject(key: String, className: Class<*>): Any?
//    fun setObject(key: String, o: Any)
    fun setLong(key: String, value: Long)
    fun getObjectInString(key: String): String
    fun removePrefValue(key: String)
    fun setFloat(key: String, value: Float)
    fun getFloat(key: String): Float
    fun getBoolean(key: String, defaultValue: Boolean): Boolean
}
