package com.netcore.android.network.models

import com.netcore.android.SMTConfigConstants
import com.netcore.android.inapp.model.SMTInAppRule
import org.json.JSONArray

/**
 * @author Netcore
 * created on 26/02/2019
 * @Description: Model class to hold the sdk initialization
 *
 */
internal class SMTSdkInitializeResponse : SMTResponse() {
    var smartechSettings: SmartTechSettings? = null
    var inAppRules: ArrayList<SMTInAppRule>? = null


    class SmartTechSettings {
        var batchInterval = SMTConfigConstants.DEFAULT_BATCH_INTERVAL
        var batchSize = SMTConfigConstants.DEFAULT_BATCH_SIZE
        var fetchLocation = SMTConfigConstants.DEFAULT_IS_FETCH_LOCATION
        var paEnabled = SMTConfigConstants.DEFAULT_IS_PUSH_AMP_ENABLED
        var paInterval = SMTConfigConstants.DEFAULT_PUSH_AMP_INTERVAL
        var panelActive = SMTConfigConstants.DEFAULT_IS_PANEL_ACTIVE
        var sdkActive = SMTConfigConstants.DEFAULT_IS_SDK_ACTIVE
        var sessionInterval = SMTConfigConstants.DEFAULT_SESSION_INTERVAL
        var baseUrl: String? = null
        var smartechURL: SmartTechBaseURL? = null
        var debuglevel: SmartTechDebugLevel? = null


        class SmartTechBaseURL {
            var trackAppActUrl: String = ""
            var pushAmpUrl: String = ""
            var inAppUrl: String = ""
            var inboxUrl: String = ""

            override fun toString(): String {
                return "SmartTechBaseURL(trackAppActUrl='$trackAppActUrl', pushAmpUrl='$pushAmpUrl', inAppUrl='$inAppUrl', inboxUrl='$inboxUrl')"
            }

        }

        class SmartTechDebugLevel {
            var logEnabled: Boolean = false
            var logLevel: Int = 0
            var guids: JSONArray = JSONArray()

            override fun toString(): String {
                return "SmartTechDebugLevel(logEnabled=$logEnabled, logLevel=$logLevel, guids=$guids)"
            }

        }

        override fun toString(): String {
            return "SmartTechSettings(batchInterval=$batchInterval, batchSize=$batchSize, fetchLocation=$fetchLocation, paEnabled=$paEnabled, paInterval=$paInterval, panelActive=$panelActive, sdkActive=$sdkActive, sessionInterval=$sessionInterval, baseUrl=$baseUrl, smartechURL=$smartechURL, debuglevel=$debuglevel)"
        }

        fun toLimitString(): String {
            return "SmartTechSettings(batchInterval=$batchInterval, batchSize=$batchSize, fetchLocation=$fetchLocation, paEnabled=$paEnabled, paInterval=$paInterval, panelActive=$panelActive, sdkActive=$sdkActive, sessionInterval=$sessionInterval)"
        }
    }

}