package com.netcore.android.mediadownloader

import android.content.Context
import java.io.File
import java.io.InputStream
import java.net.HttpURLConnection
import java.net.URL

/**
 * @author Netcore
 * created on 31/01/2019
 * @Description: Class to download all the media files except the image file
 *
 */
internal class SMTFileDownloader(val context: Context, val url: String?, var type: String,val isForInbox:Boolean=false) {

    /**
     * Method to download the file
     * @return filePath Stored file path
     */
    fun download(): String? {

        var filePath: String? = null
        url?.let {
            var connection: HttpURLConnection? = null
            var ins: InputStream? = null
            try {
                connection = URL(url).openConnection() as HttpURLConnection
                ins = connection.inputStream
                var file: File = SMTDownloaderUtility.getDownloadFile(context, url, type,isForInbox)
                filePath = ins?.let {
                    SMTDownloaderUtility.saveFileToInternalStorage(ins, file)
                }


            } catch (e: Exception) {
                e.printStackTrace()
            } finally {
                try {
                    connection?.disconnect()

                    ins?.close()
                } catch (e: Exception) {
                    e.printStackTrace()
                }

            }
        }

        return filePath;

    }

}