package com.netcore.android.logger;

import androidx.annotation.IntDef;
import androidx.annotation.Keep;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class SMTDebugLevel {

    @Keep
    @IntDef({Level.LOG_LEVEL_VERBOSE, Level.LOG_LEVEL_DEBUG, Level.LOG_LEVEL_INFO,
            Level.LOG_LEVEL_WARN, Level.LOG_LEVEL_ERROR, Level.LOG_LEVEL_FATAL, Level.LOG_LEVEL_NONE})
    @Retention(RetentionPolicy.SOURCE)
    public @interface Level {
        int LOG_LEVEL_VERBOSE = 1;
        int LOG_LEVEL_DEBUG = 2;
        int LOG_LEVEL_INFO = 3;
        int LOG_LEVEL_WARN = 4;
        int LOG_LEVEL_ERROR = 5;
        int LOG_LEVEL_FATAL = 6;
        int LOG_LEVEL_NONE = 7;
    }
}
