package com.netcore.android.inbox.views.adapter

import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.view.ViewGroup
import com.netcore.android.inbox.viewholders.*
import com.netcore.android.inbox.views.*
import com.netcore.android.notification.SMTNotificationType
import com.netcore.android.notification.models.SMTNotificationData

/**
 * Adapter to hold the recycler views
 * @param context app context
 *
 * @author Netcore
 * @version 1.0
 * @since 01-05-2019
 */
internal class SMTInboxNotificationAdapter(val context: Context) : RecyclerView.Adapter<RecyclerView.ViewHolder>() {

    /*companion object {
        const val TYPE_AUDIO = 0
        const val TYPE_SIMPLE = 1
        const val TYPE_BIG_IMAGE = 2
        const val TYPE_CAROUSEL = 3
        const val TYPE_CAROUSEL_LANDSCAPE = 4
        const val TYPE_CAROUSEL_PORTRAIT = 5
        const val TYPE_VIDEO = 6
        const val TYPE_GIF = 7
        const val TYPE_INTERACTIVE = 8
    }*/

    private val TYPE_SIMPLE = 1
    private val TYPE_BIG_IMAGE = 2
    private val TYPE_AUDIO = 3
    private val TYPE_CAROUSEL_LANDSCAPE = 4
    private val TYPE_CAROUSEL_PORTRAIT = 5
    private val TYPE_GIF = 6

    // list holds the notification data to display
    private var mMessageList: MutableList<SMTNotificationData>? = null

    /**
     * to set the data for the adapter
     * @param messages message list
     */
    fun setMessages(messages: MutableList<SMTNotificationData>) {
        mMessageList = messages
    }

    /**
     * Method performs mapping of data to view type
     * @param position - view position
     */
    override fun getItemViewType(position: Int): Int {
        return when (mMessageList?.get(position)?.mNotificationType) {
            SMTNotificationType.AUDIO.type -> TYPE_AUDIO
            SMTNotificationType.BIG_IMAGE.type -> TYPE_BIG_IMAGE
            SMTNotificationType.CAROUSEL_LANDSCAPE.type -> TYPE_CAROUSEL_LANDSCAPE
            SMTNotificationType.CAROUSEL_PORTRAIT.type -> TYPE_CAROUSEL_PORTRAIT
            SMTNotificationType.GIF.type -> TYPE_GIF
            SMTNotificationType.SIMPLE.type -> TYPE_SIMPLE
            else -> TYPE_SIMPLE
        }
    }

    /**
     * Method creates the views as per display type
     */
    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return when (viewType) {
            TYPE_CAROUSEL_LANDSCAPE -> SMTCarouselViewHolder(SMTInboxCarouselView(context, null), context)
            TYPE_CAROUSEL_PORTRAIT -> SMTCarouselViewHolder(SMTInboxCarouselView(context, null), context)
            TYPE_AUDIO -> SMTAudioViewHolder(SMTInboxAudioView(context, null), context)
            TYPE_BIG_IMAGE -> SMTBigImageViewHolder(SMTInboxImageMessageView(context, null), context)
            TYPE_GIF -> SMTGifViewHolder(SMTInboxGifMessageView(context, null), context)
            TYPE_SIMPLE -> SMTSimpleViewHolder(SMTInboxSimpleMessageView(context, null), context)
            else -> SMTSimpleViewHolder(SMTInboxSimpleMessageView(context, null), context)
        }

    }

    /**
     * method to return the size of the list
     */
    override fun getItemCount(): Int {
        return mMessageList?.size ?: 0
    }

    /**
     * Method to fetch the data as per item position
     */
    fun getItemFromPosition(index: Int): SMTNotificationData? {
        mMessageList?.let {
            if (index > -1 && index < it.size) {
                return mMessageList?.get(index)
            }
        }
        return null
    }

    /**
     * Method to update the item status to read/dismiss
     */
    fun updateItemStatus(index: Int, status: String) {
        mMessageList?.let {
            if (index > -1 && index < it.size) {
                it[index].mStatus = status
            }
        }
    }

    /**
     * Method to remove the data from the mMessageList
     */
    fun removeItemAtPosition(index: Int) {
        mMessageList?.let {
            if (index > -1 && index < it.size) {
                it.removeAt(index)
                notifyItemRemoved(index)
            }
        }
    }

    /**
     * Method to return the data list of the adapter
     */
    fun getNotificationList(): MutableList<SMTNotificationData>? {
        return mMessageList
    }

    /**
     * Method to bind the views to the ui and rendering
     */
    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        mMessageList?.let {
            (holder as SMTInboxViewHolder).bindView(it[position])
        }
    }
}