package com.netcore.android.inapp

import com.netcore.android.inapp.model.SMTInAppRule
import com.netcore.android.utility.trim
import org.json.JSONObject
import java.util.*
import kotlin.collections.ArrayList

internal class SMTInAppRuleParser {
    /**
     * Method parses the stored rule to fetch the required parameters
     */

    fun parseStoredRule(payload: String, inAppRule: SMTInAppRule) {
        inAppRule.payload = payload
        var payloadObject = JSONObject(payload)

        try {
            inAppRule.controlGroup = payloadObject.optInt("controlGroup")
        } catch (e: Exception) {
            e.printStackTrace()
        }

        try {
            inAppRule.whatTo = payloadObject.getString("whatTo")

        } catch (e: Exception) {
            e.printStackTrace()
        }

        try {
            inAppRule.contentType = payloadObject.optInt("contentType")

        } catch (e: Exception) {
            e.printStackTrace()
        }



        try {
            inAppRule.whereTo = payloadObject.getString("whereTo")
        } catch (e: Exception) {
            e.printStackTrace()
        }


        try {
            var whenToObject = payloadObject.getJSONObject("whenTo")
            var whenTo: SMTInAppRule.WhenTo = SMTInAppRule.WhenTo()
            try {
                whenTo.frequency = whenToObject.optString("frequency")
            } catch (e: Exception) {
                e.printStackTrace()
            }

            try {
                whenTo.frequencyType = whenToObject.optString("frequencyType")
            } catch (e: Exception) {
                e.printStackTrace()
            }
            try {
                whenTo.spentTime = whenToObject.getString("spentTime")
            } catch (e: Exception) {
                e.printStackTrace()
            }
            try {
//                whenTo.modifiedDate = whenToObject.getString("modifiedDate")
                whenTo.modifiedDate = SMTInAppUtility.getTimeInMilliSecForModifiedDate(whenToObject.optString("modifiedDate"))
            } catch (e: Exception) {
                e.printStackTrace()
            }

            var campainObject = whenToObject.getJSONObject("campaign")

            try {
                var occurrence: SMTInAppRule.Occurrence = SMTInAppRule.Occurrence()
                try {
                    occurrence.days = campainObject.getString("days")
                } catch (e: Exception) {
                    e.printStackTrace()
                }

                try {
                    occurrence.from = campainObject.getString("from")
                } catch (e: Exception) {
                    e.printStackTrace()
                }
                try {
                    occurrence.to = campainObject.getString("to")
                } catch (e: Exception) {
                    e.printStackTrace()
                }
                whenTo.occurrence = occurrence
            } catch (e: Exception) {
                e.printStackTrace()
            }
            inAppRule.whenTo = whenTo
        } catch (e: Exception) {
            e.printStackTrace()
        }


        try {

            var whomToObject = payloadObject.getJSONObject("whomTo")
            var whomTo: SMTInAppRule.WhomTo = SMTInAppRule.WhomTo()

            try {
                whomTo.everyone = whomToObject.getString("everyone")
            } catch (e: Exception) {
                e.printStackTrace()
            }
            try {
                whomTo.eventList = whomToObject.getString("eventList")

            } catch (e: Exception) {
                e.printStackTrace()
            }
            try {
                whomTo.eventName = whomToObject.getString("eventName").toLowerCase()
            } catch (e: Exception) {
                e.printStackTrace()
            }
            try {
                val filterArray = whomToObject.optJSONArray("filter")
                if (filterArray != null && filterArray.length() > 0) {
                    whomTo.filter = arrayListOf()
                    for (i in 0..(filterArray.length() - 1)) {
                        var filterObject = filterArray.get(i) as JSONObject
                        val filter: SMTInAppRule.Filter = SMTInAppRule.Filter()

                        try {
                            filter.filter = filterObject.optString("filter")

                        } catch (e: Exception) {
                            e.printStackTrace()
                        }

                        try {

                            filter.operator = filterObject.optString("operator").trim()
                        } catch (e: Exception) {
                            e.printStackTrace()
                        }
                        try {

                            filter.value = filterObject.optString("value").trim()

                        } catch (e: Exception) {
                            e.printStackTrace()
                        }
                        whomTo.filter!!.add(filter)
                    }
                }
            } catch (e: Exception) {
                e.printStackTrace()
            }
            inAppRule.whomTo = whomTo

        } catch (e: Exception) {
            e.printStackTrace()
        }

    }

    fun parseRule(rule: JSONObject): SMTInAppRule {
        var inAppRule = SMTInAppRule()
        inAppRule.payload = rule.toString()
        try {
            inAppRule.id = rule.optString("id")

            try {
                inAppRule.toDate = SMTInAppUtility.getTimeInMilliSec(rule.optString("toDate"))
            } catch (e: Exception) {
                e.printStackTrace()
            }
            try {
                inAppRule.fromDate = SMTInAppUtility.getTimeInMilliSec(rule.optString("fromDate"))
            } catch (e: Exception) {
                e.printStackTrace()
            }
            try {
                inAppRule.whereTo = rule.optString("whereTo")
            } catch (e: Exception) {
                e.printStackTrace()
            }

            try {
                inAppRule.whatTo = rule.optString("whatTo")
            } catch (e: Exception) {
                e.printStackTrace()
            }

            try {
                inAppRule.contentType = rule.optInt("contentType")
            } catch (e: Exception) {
                e.printStackTrace()
            }

            try {
                inAppRule.controlGroup = rule.optInt("controlGroup")
            } catch (e: Exception) {
                e.printStackTrace()
            }
            try {
                //processing whom to
                var whomToObject = rule.optJSONObject("whomTo")
                whomToObject?.let {
                    inAppRule.whomTo = SMTInAppRule.WhomTo()

                    try {
                        inAppRule.eventName = it.optString("eventName").toLowerCase()
                        inAppRule.whomTo.eventName = inAppRule.eventName
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }

                    try {
                        inAppRule.eventId = it.optString("eventList")
                        inAppRule.whomTo.eventList = inAppRule.eventId
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }

                    try {
                        inAppRule.whomTo.everyone = it.optString("everyone")
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }


                    try {
                        //processing filter
                        var filterArray = it.optJSONArray("filter")
                        if (filterArray != null && filterArray.length() > 0) {
                            inAppRule.whomTo.filter = ArrayList()
                            for (i in 0..(filterArray.length() - 1)) {
                                var filterObject: JSONObject = filterArray.get(i) as JSONObject
                                inAppRule.whomTo.filter!!.add(createFilter(filterObject))
                            }

                        }

                    } catch (e: Exception) {
                        e.printStackTrace()
                    }

                }

            } catch (e: Exception) {
                e.printStackTrace()
            }

            try {

                //Processing whenTo object

                var whenToObject = rule.optJSONObject("whenTo")
                whenToObject?.let {
                    inAppRule.whenTo = SMTInAppRule.WhenTo()

                    try {
                        inAppRule.whenTo.frequency = whenToObject.optString("frequency")
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }

                    try {
                        inAppRule.whenTo.modifiedDate = SMTInAppUtility.getTimeInMilliSecForModifiedDate(whenToObject.optString("modifiedDate"))
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }

                    try {
                        inAppRule.whenTo.frequencyType = whenToObject.optString("frequencyType")
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }

                    try {
                        inAppRule.whenTo.spentTime = whenToObject.optString("spentTime")
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }

                    try {
                        //processing occurence/campaign
                        var occurrenceObject = whenToObject.getJSONObject("campaign")
                        if (occurrenceObject != null) {
                            inAppRule.whenTo.occurrence = SMTInAppRule.Occurrence()

                            try {
                                inAppRule.whenTo.occurrence.from = occurrenceObject.optString("from")
                            } catch (e: Exception) {
                                e.printStackTrace()
                            }

                            try {
                                inAppRule.whenTo.occurrence.to = occurrenceObject.optString("to")
                            } catch (e: Exception) {
                                e.printStackTrace()
                            }

                            try {
                                inAppRule.whenTo.occurrence.days = occurrenceObject.optString("days")
                            } catch (e: Exception) {
                                e.printStackTrace()
                            }

                        }
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }
                }


            } catch (e: Exception) {
                e.printStackTrace()
            }


        } catch (e: Exception) {
            e.printStackTrace()
        }
        return inAppRule
    }

    private fun createFilter(filterObject: JSONObject): SMTInAppRule.Filter {

        var filter = SMTInAppRule.Filter()

        try {
            filter.value = filterObject.optString("value").trim()
        } catch (e: Exception) {
            e.printStackTrace()
        }

        try {
            filter.filter = filterObject.optString("filter").toLowerCase(Locale.getDefault())
        } catch (e: Exception) {
            e.printStackTrace()
        }

        try {
            filter.operator = filterObject.optString("operator").trim()
        } catch (e: Exception) {
            e.printStackTrace()
        }

        return filter
    }
}