/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.admincenter.endpoint;

import com.nepxion.discovery.common.entity.InspectorEntity;
import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.common.util.UrlUtil;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.context.PluginContextHolder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(path={"/inspector"})
@Api(tags={"\u5168\u94fe\u8def\u4fa6\u6d4b\u63a5\u53e3"})
public class InspectorEndpoint {
    @Autowired
    private RestTemplate pluginRestTemplate;
    @Autowired
    private PluginAdapter pluginAdapter;
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired(required=false)
    private PluginContextHolder pluginContextHolder;

    @RequestMapping(path={"/inspect"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4fa6\u6d4b\u5168\u94fe\u8def\u8def\u7531", notes="", response=InspectorEntity.class, httpMethod="POST")
    @ResponseBody
    public InspectorEntity inspect(@RequestBody @ApiParam(value="\u4fa6\u6d4b\u5bf9\u8c61", required=true) InspectorEntity inspectorEntity) {
        List serviceIdList = inspectorEntity.getServiceIdList();
        String result = inspectorEntity.getResult();
        if (StringUtils.isEmpty((CharSequence)result) && this.pluginContextHolder != null) {
            result = this.pluginContextHolder.getContext("endpoint-inspector-inspect");
        }
        inspectorEntity.setResult(this.pluginAdapter.getPluginInfo(result));
        if (CollectionUtils.isNotEmpty((Collection)serviceIdList)) {
            String serviceId = (String)serviceIdList.get(0);
            String contextPath = this.getContextPath(serviceId);
            String url = "http://" + serviceId + UrlUtil.formatContextPath((String)contextPath) + "/inspector/inspect";
            serviceIdList.remove(0);
            try {
                return (InspectorEntity)this.pluginRestTemplate.postForEntity(url, (Object)inspectorEntity, InspectorEntity.class, new Object[0]).getBody();
            }
            catch (RestClientException e) {
                throw new DiscoveryException("Failed to execute to inspect, serviceId=" + serviceId + ", url=" + url, (Throwable)e);
            }
        }
        return inspectorEntity;
    }

    private String getContextPath(String serviceId) {
        ServiceInstance instance = null;
        try {
            instance = (ServiceInstance)this.discoveryClient.getInstances(serviceId).get(0);
        }
        catch (Exception e) {
            throw new DiscoveryException("Failed to execute to inspect, serviceId=" + serviceId, (Throwable)e);
        }
        return this.pluginAdapter.getInstanceContextPath(instance);
    }
}

