/*
 * Decompiled with CFR 0.152.
 */
package com.neovisionaries.ws.client;

import com.neovisionaries.ws.client.Base64;
import com.neovisionaries.ws.client.Token;
import com.neovisionaries.ws.client.WebSocketExtension;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HandshakeBuilder {
    private static final String RN = "\r\n";
    private boolean mSecure;
    private String mUserInfo;
    private final String mHost;
    private final String mPath;
    private final URI mUri;
    private String mKey;
    private Set<String> mProtocols;
    private List<WebSocketExtension> mExtensions;
    private List<String[]> mHeaders;

    public HandshakeBuilder(boolean secure, String userInfo, String host, String path) {
        this.mSecure = secure;
        this.mUserInfo = userInfo;
        this.mHost = host;
        this.mPath = path;
        this.mUri = URI.create(String.format("%s://%s%s", secure ? "wss" : "ws", host, path));
    }

    public HandshakeBuilder(HandshakeBuilder source) {
        this.mSecure = source.mSecure;
        this.mUserInfo = source.mUserInfo;
        this.mHost = source.mHost;
        this.mPath = source.mPath;
        this.mUri = source.mUri;
        this.mKey = source.mKey;
        this.mProtocols = HandshakeBuilder.copyProtocols(source.mProtocols);
        this.mExtensions = HandshakeBuilder.copyExtensions(source.mExtensions);
        this.mHeaders = HandshakeBuilder.copyHeaders(source.mHeaders);
    }

    public void addProtocol(String protocol) {
        if (!HandshakeBuilder.isValidProtocol(protocol)) {
            throw new IllegalArgumentException("'protocol' must be a non-empty string with characters in the range U+0021 to U+007E not including separator characters.");
        }
        if (this.mProtocols == null) {
            this.mProtocols = new LinkedHashSet<String>();
        }
        this.mProtocols.add(protocol);
    }

    private static boolean isValidProtocol(String protocol) {
        if (protocol == null || protocol.length() == 0) {
            return false;
        }
        int len = protocol.length();
        for (int i = 0; i < len; ++i) {
            char ch = protocol.charAt(i);
            if (ch >= '!' && '~' >= ch && !Token.isSeparator(ch)) continue;
            return false;
        }
        return true;
    }

    public boolean containsProtocol(String protocol) {
        if (this.mProtocols == null) {
            return false;
        }
        return this.mProtocols.contains(protocol);
    }

    public void addExtension(WebSocketExtension extension) {
        if (extension == null) {
            return;
        }
        if (this.mExtensions == null) {
            this.mExtensions = new ArrayList<WebSocketExtension>();
        }
        this.mExtensions.add(extension);
    }

    public boolean containsExtension(String extensionName) {
        if (this.mExtensions == null) {
            return false;
        }
        for (WebSocketExtension extension : this.mExtensions) {
            if (!extension.getName().equals(extensionName)) continue;
            return true;
        }
        return false;
    }

    public void addHeader(String name, String value) {
        if (name == null || name.length() == 0) {
            return;
        }
        if (value == null) {
            value = "";
        }
        if (this.mHeaders == null) {
            this.mHeaders = new ArrayList<String[]>();
        }
        this.mHeaders.add(new String[]{name, value});
    }

    public void setUserInfo(String userInfo) {
        this.mUserInfo = userInfo;
    }

    public void setUserInfo(String id, String password) {
        if (id == null) {
            id = "";
        }
        if (password == null) {
            password = "";
        }
        String userInfo = String.format("%s:%s", id, password);
        this.setUserInfo(userInfo);
    }

    public URI getURI() {
        return this.mUri;
    }

    public void setKey(String key) {
        this.mKey = key;
    }

    public String build() {
        StringBuilder builder = new StringBuilder().append("GET ").append(this.mPath).append(" HTTP/1.1").append(RN).append("Host: ").append(this.mHost).append(RN).append("Connection: Upgrade").append(RN).append("Upgrade: websocket").append(RN).append("Sec-WebSocket-Version: 13").append(RN).append("Sec-WebSocket-Key: ").append(this.mKey).append(RN);
        HandshakeBuilder.append(builder, "Sec-WebSocket-Protocol", this.mProtocols);
        HandshakeBuilder.append(builder, "Sec-WebSocket-Extensions", this.mExtensions);
        HandshakeBuilder.append(builder, this.mHeaders);
        if (this.mUserInfo != null && this.mUserInfo.length() != 0) {
            builder.append("Authorization: Basic ").append(Base64.encode(this.mUserInfo)).append(RN);
        }
        return builder.append(RN).toString();
    }

    private static void append(StringBuilder builder, String name, Collection<?> values) {
        if (values == null || values.size() == 0) {
            return;
        }
        builder.append(name).append(": ");
        HandshakeBuilder.join(builder, values, ", ");
        builder.append(RN);
    }

    private static void join(StringBuilder builder, Collection<?> values, String delimiter) {
        boolean first = true;
        for (Object value : values) {
            if (first) {
                first = false;
            } else {
                builder.append(delimiter);
            }
            builder.append(value.toString());
        }
    }

    private static void append(StringBuilder builder, List<String[]> pairs) {
        if (pairs == null || pairs.size() == 0) {
            return;
        }
        for (String[] pair : pairs) {
            builder.append(pair[0]).append(": ").append(pair[1]).append(RN);
        }
    }

    private static Set<String> copyProtocols(Set<String> protocols) {
        if (protocols == null) {
            return null;
        }
        LinkedHashSet<String> newProtocols = new LinkedHashSet<String>(protocols.size());
        newProtocols.addAll(protocols);
        return newProtocols;
    }

    private static List<WebSocketExtension> copyExtensions(List<WebSocketExtension> extensions) {
        if (extensions == null) {
            return null;
        }
        ArrayList<WebSocketExtension> newExtensions = new ArrayList<WebSocketExtension>(extensions.size());
        for (WebSocketExtension extension : extensions) {
            newExtensions.add(new WebSocketExtension(extension));
        }
        return newExtensions;
    }

    private static List<String[]> copyHeaders(List<String[]> headers) {
        if (headers == null) {
            return null;
        }
        ArrayList<String[]> newHeaders = new ArrayList<String[]>(headers.size());
        for (String[] header : headers) {
            newHeaders.add(HandshakeBuilder.copyHeader(header));
        }
        return newHeaders;
    }

    private static String[] copyHeader(String[] header) {
        String[] newHeader = new String[]{header[0], header[1]};
        return newHeader;
    }
}

