/*
 * Decompiled with CFR 0.152.
 */
package com.neovisionaries.ws.client;

import com.neovisionaries.ws.client.ProxyHandshaker;
import com.neovisionaries.ws.client.ProxySettings;
import com.neovisionaries.ws.client.SocketFactorySettings;
import com.neovisionaries.ws.client.WebSocket;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class WebSocketFactory {
    private final SocketFactorySettings mSocketFactorySettings = new SocketFactorySettings();
    private final ProxySettings mProxySettings = new ProxySettings(this);
    private int mConnectionTimeout;

    public SocketFactory getSocketFactory() {
        return this.mSocketFactorySettings.getSocketFactory();
    }

    public WebSocketFactory setSocketFactory(SocketFactory factory) {
        this.mSocketFactorySettings.setSocketFactory(factory);
        return this;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.mSocketFactorySettings.getSSLSocketFactory();
    }

    public WebSocketFactory setSSLSocketFactory(SSLSocketFactory factory) {
        this.mSocketFactorySettings.setSSLSocketFactory(factory);
        return this;
    }

    public SSLContext getSSLContext() {
        return this.mSocketFactorySettings.getSSLContext();
    }

    public WebSocketFactory setSSLContext(SSLContext context) {
        this.mSocketFactorySettings.setSSLContext(context);
        return this;
    }

    public ProxySettings getProxySettings() {
        return this.mProxySettings;
    }

    public int getConnectionTimeout() {
        return this.mConnectionTimeout;
    }

    public WebSocketFactory setConnectionTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout value cannot be negative.");
        }
        this.mConnectionTimeout = timeout;
        return this;
    }

    public WebSocket createSocket(String uri) throws IOException {
        return this.createSocket(uri, this.getConnectionTimeout());
    }

    public WebSocket createSocket(String uri, int timeout) throws IOException {
        if (uri == null) {
            throw new IllegalArgumentException("The given URI is null.");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("The given timeout value is negative.");
        }
        return this.createSocket(URI.create(uri), timeout);
    }

    public WebSocket createSocket(URL url) throws IOException {
        return this.createSocket(url, this.getConnectionTimeout());
    }

    public WebSocket createSocket(URL url, int timeout) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("The given URL is null.");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("The given timeout value is negative.");
        }
        try {
            return this.createSocket(url.toURI(), timeout);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to convert the given URL into a URI.");
        }
    }

    public WebSocket createSocket(URI uri) throws IOException {
        return this.createSocket(uri, this.getConnectionTimeout());
    }

    public WebSocket createSocket(URI uri, int timeout) throws IOException {
        if (uri == null) {
            throw new IllegalArgumentException("The given URI is null.");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("The given timeout value is negative.");
        }
        String scheme = uri.getScheme();
        String userInfo = uri.getUserInfo();
        String host = uri.getHost();
        int port = uri.getPort();
        String path = uri.getPath();
        String query = uri.getQuery();
        return this.createSocket(scheme, userInfo, host, port, path, query, timeout);
    }

    private WebSocket createSocket(String scheme, String userInfo, String host, int port, String path, String query, int timeout) throws IOException {
        boolean secure = WebSocketFactory.isSecureConnectionRequired(scheme);
        if (host == null || host.length() == 0) {
            throw new IllegalArgumentException("The host part is empty.");
        }
        path = WebSocketFactory.determinePath(path);
        Socket socket = this.createRawSocket(host, port, secure, timeout);
        return this.createWebSocket(secure, userInfo, host, port, path, query, socket, timeout);
    }

    private static boolean isSecureConnectionRequired(String scheme) {
        if (scheme == null || scheme.length() == 0) {
            throw new IllegalArgumentException("The scheme part is empty.");
        }
        if ("wss".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
            return true;
        }
        if ("ws".equalsIgnoreCase(scheme) || "http".equalsIgnoreCase(scheme)) {
            return false;
        }
        throw new IllegalArgumentException("Bad scheme: " + scheme);
    }

    private static String determinePath(String path) {
        if (path == null || path.length() == 0) {
            return "/";
        }
        if (path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }

    private Socket createRawSocket(String host, int port, boolean secure, int timeout) throws IOException {
        boolean proxied;
        port = WebSocketFactory.determinePort(port, secure);
        boolean bl = proxied = this.mProxySettings.getHost() != null;
        if (proxied) {
            return this.createProxiedRawSocket(host, port, secure, timeout);
        }
        return this.createDirectRawSocket(host, port, secure, timeout);
    }

    private Socket createProxiedRawSocket(String host, int port, boolean secure, int timeout) throws IOException {
        int proxyPort = WebSocketFactory.determinePort(this.mProxySettings.getPort(), this.mProxySettings.isSecure());
        SocketFactory factory = this.mProxySettings.selectSocketFactory();
        Socket socket = factory.createSocket();
        socket.connect(new InetSocketAddress(this.mProxySettings.getHost(), proxyPort), timeout);
        try {
            return this.doProxyHandshake(socket, host, port, secure);
        }
        catch (IOException e) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    private Socket doProxyHandshake(Socket socket, String host, int port, boolean secure) throws IOException {
        new ProxyHandshaker(socket, host, port, this.mProxySettings).perform();
        if (secure) {
            SSLSocketFactory sslSocketFactory = (SSLSocketFactory)this.mSocketFactorySettings.selectSocketFactory(secure);
            socket = sslSocketFactory.createSocket(socket, host, port, true);
            ((SSLSocket)socket).startHandshake();
        }
        return socket;
    }

    private Socket createDirectRawSocket(String host, int port, boolean secure, int timeout) throws IOException {
        SocketFactory factory = this.mSocketFactorySettings.selectSocketFactory(secure);
        Socket socket = factory.createSocket();
        socket.connect(new InetSocketAddress(host, port), timeout);
        return socket;
    }

    private static int determinePort(int port, boolean secure) {
        if (0 <= port) {
            return port;
        }
        if (secure) {
            return 443;
        }
        return 80;
    }

    private WebSocket createWebSocket(boolean secure, String userInfo, String host, int port, String path, String query, Socket socket, int timeout) {
        if (0 <= port) {
            host = host + ":" + port;
        }
        if (query != null) {
            path = path + "?" + query;
        }
        return new WebSocket(this, secure, userInfo, host, path, socket, timeout);
    }
}

