/*
 * Decompiled with CFR 0.152.
 */
package com.ncapdevi.fragnav;

import android.os.Bundle;
import android.support.annotation.CheckResult;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.json.JSONArray;

public class FragNavController {
    public static final int TAB1 = 0;
    public static final int TAB2 = 1;
    public static final int TAB3 = 2;
    public static final int TAB4 = 3;
    public static final int TAB5 = 4;
    private static final String EXTRA_TAG_COUNT = FragNavController.class.getName() + ":EXTRA_TAG_COUNT";
    private static final String EXTRA_SELECTED_TAB_INDEX = FragNavController.class.getName() + ":EXTRA_SELECTED_TAB_INDEX";
    private static final String EXTRA_CURRENT_FRAGMENT = FragNavController.class.getName() + ":EXTRA_CURRENT_FRAGMENT";
    private static final String EXTRA_FRAGMENT_STACK = FragNavController.class.getName() + ":EXTRA_FRAGMENT_STACK";
    @IdRes
    private final int mContainerId;
    @NonNull
    private final List<Stack<Fragment>> mFragmentStacks;
    @NonNull
    private final FragmentManager mFragmentManager;
    private int mSelectedTabIndex = -1;
    private int mTagCount;
    @Nullable
    private Fragment mCurrentFrag;
    @Nullable
    private DialogFragment mCurrentDialogFrag;
    @Nullable
    private RootFragmentListener mRootFragmentListener;
    @Nullable
    private TransactionListener mTransactionListener;
    private int mTransitionMode = -1;
    private boolean mExecutingTransaction;

    private FragNavController(@NonNull FragmentManager fragmentManager, @IdRes int containerId, int numberOfTabs) {
        this.mFragmentManager = fragmentManager;
        this.mContainerId = containerId;
        this.mFragmentStacks = new ArrayList<Stack<Fragment>>(numberOfTabs);
    }

    public FragNavController(Bundle savedInstanceState, @NonNull FragmentManager fragmentManager, @IdRes int containerId, @NonNull Fragment rootFragment) {
        this(fragmentManager, containerId, 1);
        ArrayList<Fragment> rootFragments = new ArrayList<Fragment>(1);
        rootFragments.add(rootFragment);
        if (!this.restoreFromBundle(savedInstanceState, rootFragments)) {
            Stack<Fragment> stack = new Stack<Fragment>();
            stack.add(rootFragment);
            this.mFragmentStacks.add(stack);
            this.initialize(0);
        }
    }

    public FragNavController(Bundle savedInstanceState, @NonNull FragmentManager fragmentManager, @IdRes int containerId, @NonNull List<Fragment> rootFragments, int startingIndex) {
        this(fragmentManager, containerId, rootFragments.size());
        if (startingIndex > rootFragments.size()) {
            throw new IndexOutOfBoundsException("Starting index cannot be larger than the number of stacks");
        }
        if (!this.restoreFromBundle(savedInstanceState, rootFragments)) {
            for (Fragment fragment : rootFragments) {
                Stack<Fragment> stack = new Stack<Fragment>();
                stack.add(fragment);
                this.mFragmentStacks.add(stack);
            }
            this.initialize(startingIndex);
        }
    }

    public FragNavController(Bundle savedInstanceState, @NonNull FragmentManager fragmentManager, @IdRes int containerId, RootFragmentListener rootFragmentListener, int numberOfTabs, int startingIndex) {
        this(fragmentManager, containerId, numberOfTabs);
        if (startingIndex > numberOfTabs) {
            throw new IndexOutOfBoundsException("Starting index cannot be larger than the number of stacks");
        }
        this.setRootFragmentListener(rootFragmentListener);
        if (!this.restoreFromBundle(savedInstanceState, null)) {
            for (int i = 0; i < numberOfTabs; ++i) {
                this.mFragmentStacks.add(new Stack());
            }
            this.initialize(startingIndex);
        }
    }

    public void setRootFragmentListener(RootFragmentListener rootFragmentListener) {
        this.mRootFragmentListener = rootFragmentListener;
    }

    public void setTransactionListener(TransactionListener transactionListener) {
        this.mTransactionListener = transactionListener;
    }

    public void setTransitionMode(int transitionMode) {
        this.mTransitionMode = transitionMode;
    }

    public void switchTab(int index) throws IndexOutOfBoundsException {
        if (index >= this.mFragmentStacks.size()) {
            throw new IndexOutOfBoundsException("Can't switch to a tab that hasn't been initialized, Index : " + index + ", current stack size : " + this.mFragmentStacks.size() + ". Make sure to create all of the tabs you need in the Constructor or provide a way for them to be created via RootFragmentListener.");
        }
        if (this.mSelectedTabIndex != index) {
            this.mSelectedTabIndex = index;
            FragmentTransaction ft = this.mFragmentManager.beginTransaction();
            ft.setTransition(this.mTransitionMode);
            this.detachCurrentFragment(ft);
            Fragment fragment = this.reattachPreviousFragment(ft);
            if (fragment != null) {
                ft.commit();
            } else {
                fragment = this.getRootFragment(this.mSelectedTabIndex);
                ft.add(this.mContainerId, fragment, this.generateTag(fragment));
                ft.commit();
            }
            this.executePendingTransactions();
            this.mCurrentFrag = fragment;
            if (this.mTransactionListener != null) {
                this.mTransactionListener.onTabTransaction(this.mCurrentFrag, this.mSelectedTabIndex);
            }
        }
    }

    public void pushFragment(@Nullable Fragment fragment) {
        if (fragment != null) {
            FragmentTransaction ft = this.mFragmentManager.beginTransaction();
            ft.setTransition(this.mTransitionMode);
            this.detachCurrentFragment(ft);
            ft.add(this.mContainerId, fragment, this.generateTag(fragment));
            ft.commit();
            this.executePendingTransactions();
            this.mFragmentStacks.get(this.mSelectedTabIndex).push(fragment);
            this.mCurrentFrag = fragment;
            if (this.mTransactionListener != null) {
                this.mTransactionListener.onFragmentTransaction(this.mCurrentFrag);
            }
        }
    }

    @Deprecated
    public void push(@Nullable Fragment fragment) {
        this.pushFragment(fragment);
    }

    public void popFragment() throws UnsupportedOperationException {
        this.popFragments(1);
    }

    @Deprecated
    public void pop() throws UnsupportedOperationException {
        this.popFragments(1);
    }

    public void popFragments(int popDepth) throws UnsupportedOperationException {
        Fragment fragment;
        if (this.isRootFragment()) {
            throw new UnsupportedOperationException("You can not popFragment the rootFragment. If you need to change this fragment, use replaceFragment(fragment)");
        }
        if (popDepth < 1) {
            throw new UnsupportedOperationException("popFragments parameter needs to be greater than 0");
        }
        if (popDepth >= this.mFragmentStacks.get(this.mSelectedTabIndex).size() - 1) {
            this.clearStack();
            return;
        }
        FragmentTransaction ft = this.mFragmentManager.beginTransaction();
        ft.setTransition(this.mTransitionMode);
        for (int i = 0; i < popDepth; ++i) {
            fragment = this.mFragmentManager.findFragmentByTag(this.mFragmentStacks.get(this.mSelectedTabIndex).pop().getTag());
            if (fragment == null) continue;
            ft.remove(fragment);
        }
        fragment = this.reattachPreviousFragment(ft);
        boolean bShouldPush = false;
        if (fragment != null) {
            ft.commit();
        } else if (!this.mFragmentStacks.get(this.mSelectedTabIndex).isEmpty()) {
            fragment = this.mFragmentStacks.get(this.mSelectedTabIndex).peek();
            ft.add(this.mContainerId, fragment, fragment.getTag());
            ft.commit();
        } else {
            fragment = this.getRootFragment(this.mSelectedTabIndex);
            ft.add(this.mContainerId, fragment, this.generateTag(fragment));
            ft.commit();
            bShouldPush = true;
        }
        this.executePendingTransactions();
        if (bShouldPush) {
            this.mFragmentStacks.get(this.mSelectedTabIndex).push(fragment);
        }
        this.mCurrentFrag = fragment;
        if (this.mTransactionListener != null) {
            this.mTransactionListener.onFragmentTransaction(this.mCurrentFrag);
        }
    }

    public void clearStack() {
        Stack<Fragment> fragmentStack = this.mFragmentStacks.get(this.mSelectedTabIndex);
        if (fragmentStack.size() > 1) {
            Fragment fragment;
            FragmentTransaction ft = this.mFragmentManager.beginTransaction();
            ft.setTransition(this.mTransitionMode);
            while (fragmentStack.size() > 1) {
                fragment = this.mFragmentManager.findFragmentByTag(fragmentStack.pop().getTag());
                if (fragment == null) continue;
                ft.remove(fragment);
            }
            fragment = this.reattachPreviousFragment(ft);
            boolean bShouldPush = false;
            if (fragment != null) {
                ft.commit();
            } else if (!fragmentStack.isEmpty()) {
                fragment = fragmentStack.peek();
                ft.add(this.mContainerId, fragment, fragment.getTag());
                ft.commit();
            } else {
                fragment = this.getRootFragment(this.mSelectedTabIndex);
                ft.add(this.mContainerId, fragment, this.generateTag(fragment));
                ft.commit();
                bShouldPush = true;
            }
            this.executePendingTransactions();
            if (bShouldPush) {
                this.mFragmentStacks.get(this.mSelectedTabIndex).push(fragment);
            }
            this.mFragmentStacks.set(this.mSelectedTabIndex, fragmentStack);
            this.mCurrentFrag = fragment;
            if (this.mTransactionListener != null) {
                this.mTransactionListener.onFragmentTransaction(this.mCurrentFrag);
            }
        }
    }

    public void replaceFragment(@NonNull Fragment fragment) {
        Fragment poppingFrag = this.getCurrentFrag();
        if (poppingFrag != null) {
            FragmentTransaction ft = this.mFragmentManager.beginTransaction();
            ft.setTransition(this.mTransitionMode);
            Stack<Fragment> fragmentStack = this.mFragmentStacks.get(this.mSelectedTabIndex);
            if (!fragmentStack.isEmpty()) {
                fragmentStack.pop();
            }
            String tag = this.generateTag(fragment);
            ft.replace(this.mContainerId, fragment, tag);
            ft.commit();
            this.executePendingTransactions();
            fragmentStack.push(fragment);
            this.mCurrentFrag = fragment;
            if (this.mTransactionListener != null) {
                this.mTransactionListener.onFragmentTransaction(this.mCurrentFrag);
            }
        }
    }

    public void replace(@NonNull Fragment fragment) {
        this.replaceFragment(fragment);
    }

    private void initialize(int index) {
        this.mSelectedTabIndex = index;
        this.clearFragmentManager();
        this.clearDialogFragment();
        FragmentTransaction ft = this.mFragmentManager.beginTransaction();
        ft.setTransition(this.mTransitionMode);
        Fragment fragment = this.getRootFragment(index);
        ft.add(this.mContainerId, fragment, this.generateTag(fragment));
        ft.commit();
        this.executePendingTransactions();
        this.mCurrentFrag = fragment;
        if (this.mTransactionListener != null) {
            this.mTransactionListener.onTabTransaction(this.mCurrentFrag, this.mSelectedTabIndex);
        }
    }

    @NonNull
    @CheckResult
    private Fragment getRootFragment(int index) throws IllegalStateException {
        Fragment fragment = null;
        if (!this.mFragmentStacks.get(index).isEmpty()) {
            fragment = this.mFragmentStacks.get(index).peek();
        } else if (this.mRootFragmentListener != null) {
            fragment = this.mRootFragmentListener.getRootFragment(index);
            this.mFragmentStacks.get(this.mSelectedTabIndex).push(fragment);
        }
        if (fragment == null) {
            throw new IllegalStateException("Either you haven't past in a fragment at this index in your constructor, or you haven'tprovided a way to create it while via your RootFragmentListener.getRootFragment(index)");
        }
        return fragment;
    }

    @Nullable
    private Fragment reattachPreviousFragment(@NonNull FragmentTransaction ft) {
        Stack<Fragment> fragmentStack = this.mFragmentStacks.get(this.mSelectedTabIndex);
        Fragment fragment = null;
        if (!fragmentStack.isEmpty() && (fragment = this.mFragmentManager.findFragmentByTag(fragmentStack.peek().getTag())) != null) {
            ft.attach(fragment);
        }
        return fragment;
    }

    private void detachCurrentFragment(@NonNull FragmentTransaction ft) {
        Fragment oldFrag = this.getCurrentFrag();
        if (oldFrag != null) {
            ft.detach(oldFrag);
        }
    }

    @Nullable
    @CheckResult
    public Fragment getCurrentFrag() {
        if (this.mCurrentFrag != null) {
            return this.mCurrentFrag;
        }
        Stack<Fragment> fragmentStack = this.mFragmentStacks.get(this.mSelectedTabIndex);
        if (!fragmentStack.isEmpty()) {
            this.mCurrentFrag = this.mFragmentManager.findFragmentByTag(this.mFragmentStacks.get(this.mSelectedTabIndex).peek().getTag());
        }
        return this.mCurrentFrag;
    }

    @NonNull
    @CheckResult
    private String generateTag(@NonNull Fragment fragment) {
        return fragment.getClass().getName() + ++this.mTagCount;
    }

    private void executePendingTransactions() {
        if (!this.mExecutingTransaction) {
            this.mExecutingTransaction = true;
            this.mFragmentManager.executePendingTransactions();
            this.mExecutingTransaction = false;
        }
    }

    private void clearFragmentManager() {
        if (this.mFragmentManager.getFragments() != null) {
            FragmentTransaction ft = this.mFragmentManager.beginTransaction();
            ft.setTransition(this.mTransitionMode);
            for (Fragment fragment : this.mFragmentManager.getFragments()) {
                if (fragment == null) continue;
                ft.remove(fragment);
            }
            ft.commit();
            this.executePendingTransactions();
        }
    }

    @CheckResult
    public int getSize() {
        return this.mFragmentStacks.size();
    }

    @CheckResult
    @NonNull
    public Stack<Fragment> getCurrentStack() {
        return (Stack)this.mFragmentStacks.get(this.mSelectedTabIndex).clone();
    }

    @Deprecated
    @CheckResult
    public boolean canPop() {
        return this.getCurrentStack().size() > 1;
    }

    @CheckResult
    public boolean isRootFragment() {
        return this.getCurrentStack().size() == 1;
    }

    @Nullable
    @CheckResult
    public DialogFragment getCurrentDialogFrag() {
        if (this.mCurrentDialogFrag != null) {
            return this.mCurrentDialogFrag;
        }
        FragmentManager fragmentManager = this.mCurrentFrag != null ? this.mCurrentFrag.getChildFragmentManager() : this.mFragmentManager;
        if (fragmentManager.getFragments() != null) {
            for (Fragment fragment : fragmentManager.getFragments()) {
                if (!(fragment instanceof DialogFragment)) continue;
                this.mCurrentDialogFrag = (DialogFragment)fragment;
                break;
            }
        }
        return this.mCurrentDialogFrag;
    }

    public void clearDialogFragment() {
        if (this.mCurrentDialogFrag != null) {
            this.mCurrentDialogFrag.dismiss();
            this.mCurrentDialogFrag = null;
        } else {
            FragmentManager fragmentManager = this.mCurrentFrag != null ? this.mCurrentFrag.getChildFragmentManager() : this.mFragmentManager;
            if (fragmentManager.getFragments() != null) {
                for (Fragment fragment : fragmentManager.getFragments()) {
                    if (!(fragment instanceof DialogFragment)) continue;
                    ((DialogFragment)fragment).dismiss();
                }
            }
        }
    }

    public void showDialogFragment(@Nullable DialogFragment dialogFragment) {
        if (dialogFragment != null) {
            FragmentManager fragmentManager = this.mCurrentFrag != null ? this.mCurrentFrag.getChildFragmentManager() : this.mFragmentManager;
            if (fragmentManager.getFragments() != null) {
                for (Fragment fragment : fragmentManager.getFragments()) {
                    if (!(fragment instanceof DialogFragment)) continue;
                    ((DialogFragment)fragment).dismiss();
                    this.mCurrentDialogFrag = null;
                }
            }
            this.mCurrentDialogFrag = dialogFragment;
            try {
                dialogFragment.show(fragmentManager, dialogFragment.getClass().getName());
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        outState.putInt(EXTRA_TAG_COUNT, this.mTagCount);
        outState.putInt(EXTRA_SELECTED_TAB_INDEX, this.mSelectedTabIndex);
        if (this.mCurrentFrag != null) {
            outState.putString(EXTRA_CURRENT_FRAGMENT, this.mCurrentFrag.getTag());
        }
        try {
            JSONArray stackArrays = new JSONArray();
            for (Stack<Fragment> stack : this.mFragmentStacks) {
                JSONArray stackArray = new JSONArray();
                for (Fragment fragment : stack) {
                    stackArray.put((Object)fragment.getTag());
                }
                stackArrays.put((Object)stackArray);
            }
            outState.putString(EXTRA_FRAGMENT_STACK, stackArrays.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean restoreFromBundle(@Nullable Bundle savedInstanceState, @Nullable List<Fragment> rootFragments) {
        if (savedInstanceState == null) {
            return false;
        }
        this.mTagCount = savedInstanceState.getInt(EXTRA_TAG_COUNT, 0);
        this.mCurrentFrag = this.mFragmentManager.findFragmentByTag(savedInstanceState.getString(EXTRA_CURRENT_FRAGMENT));
        try {
            JSONArray stackArrays = new JSONArray(savedInstanceState.getString(EXTRA_FRAGMENT_STACK));
            for (int x = 0; x < stackArrays.length(); ++x) {
                JSONArray stackArray = stackArrays.getJSONArray(x);
                Stack<Fragment> stack = new Stack<Fragment>();
                if (stackArray.length() == 1) {
                    String tag = stackArray.getString(0);
                    Fragment fragment = tag == null || "null".equalsIgnoreCase(tag) ? (rootFragments != null ? rootFragments.get(x) : this.getRootFragment(x)) : this.mFragmentManager.findFragmentByTag(tag);
                    if (fragment != null) {
                        stack.add(fragment);
                    }
                } else {
                    for (int y = 0; y < stackArray.length(); ++y) {
                        Fragment fragment;
                        String tag = stackArray.getString(y);
                        if (tag == null || "null".equalsIgnoreCase(tag) || (fragment = this.mFragmentManager.findFragmentByTag(tag)) == null) continue;
                        stack.add(fragment);
                    }
                }
                this.mFragmentStacks.add(stack);
            }
            switch (savedInstanceState.getInt(EXTRA_SELECTED_TAB_INDEX)) {
                case 0: {
                    this.switchTab(0);
                    break;
                }
                case 1: {
                    this.switchTab(1);
                    break;
                }
                case 2: {
                    this.switchTab(2);
                    break;
                }
                case 3: {
                    this.switchTab(3);
                    break;
                }
                case 4: {
                    this.switchTab(4);
                }
            }
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static interface TransactionListener {
        public void onTabTransaction(Fragment var1, int var2);

        public void onFragmentTransaction(Fragment var1);
    }

    public static interface RootFragmentListener {
        public Fragment getRootFragment(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TabIndex {
    }
}

