<template>
    <div>
        <el-dialog title="提示" :visible.sync="dialogVisible" width="30%">
            <span>确认要删除该条数据吗?</span>
            <span slot="footer" class="dialog-footer">
                <el-button @click="dialogVisible = false">取 消</el-button>
                <el-button type="primary" @click="handleClose">确 定</el-button>
            </span>
        </el-dialog>
        <div class="search">
            <el-form label-width="${bean.searchWidth!80}px">
                <el-row>
                    <#if searchs??>
                    <#list searchs as item>
                    <#if item.show>
                    <el-col :span="6" style="padding: 0 8px;">
                        <el-form-item label="${item.title}">
                        <#if item.type='date'>
                            <el-date-picker value-format="yyyy-MM-dd" size="small" v-model="searchObject.${item.id!}" type="date" placeholder="选择日期">
                            </el-date-picker>
                            <#elseif item.type='select'>
                            <el-select size="small" style="width: 100%;"  v-model="searchObject.${item.id!}" filterable clearable
                                       placeholder="请选择">
                                <el-option v-for="item in ${item.id!}Options" :key="item.id"
                                           :label="item.name" :value="item.id">
                                </el-option>
                            </el-select>
                            <#elseif item.type='textarea'>
                            <el-input v-model="searchObject.${item.id!}" size="small" name="${item.id!}" type="textarea"></el-input>
                            <#else>
                            <el-input v-model="searchObject.${item.id!}" size="small" placeholder="${item.placeholder}" name="${item.id!}">
                            </el-input>
                        </#if>
                        </el-form-item>
                    </el-col>
                    </#if>
                </#list>
            </#if>

            <el-col :span="${leftSize!'6'}" style="padding: 0 10px;margin-top: 5px;">
                <el-row type="flex" justify="end">
                    <el-button size="small" type="primary" @click="search">搜索</el-button>
                    <el-button size="small" plain @click="clearData">清除条件</el-button>
                </el-row>
            </el-col>
            </el-row>
            </el-form>
        </div>
        <div class="data-content">
            <div  class="tool-add">
                <el-button type="primary" size="small" @click="addView">新增</el-button>
            </div>

            <el-table v-loading="loading" :data="tableData.list"   @sort-change="changeTableSort" style="width: 100%;font-size: 12px;">
                <#if bean.grids??>
                    <#list bean.grids as item>
                        <el-table-column label="${item.title}"

                                        prop="${item.id!}${item.extName!}"
                        <#if item.sort>sortable="custom" </#if>
                        <#if item.width?length lt 4 > width="${item.width!}"  </#if>
                        >
                        </el-table-column>
                    </#list>
                </#if>
                <el-table-column width="180" align="center" fixed="right" label="操作">
                    <template slot-scope="scope">
                         <el-button type="text" size="mini" icon="el-icon-info" @click="show(scope.row)">详情
                         </el-button>

                         <el-button type="text" size="mini" icon="el-icon-edit" @click="editView(scope.row)">编辑
                         </el-button>

                         <el-button type="text" icon="el-icon-delete" class="danger" size="mini" style="cursor: pointer;"
                                @click="deleteData(scope.row)">删除
                         </el-button>                   
                    </template>
                </el-table-column>
                </el-table>

            <div class="page">
                <el-pagination background :current-page="searchObject.no" :page-sizes="[10, 20, 50, 100]"
                            :page-size="tableData.size" :pager-count="5"
                            layout="total, sizes, prev, pager, next, jumper" :page-count="tableData.totalPage"
                            :total="tableData.total" @size-change="sizeChange" @current-change="pageChange">
                </el-pagination>
            </div>
        </div>
    </div>
</template>

<script>
  import common from "@/mixins/common.js";
  var config = {};


  config.methods = {};
  config.methods.addView = function () {
    this.$router.push({
      path: 'add'
    });
  }
  config.methods.auditView = function (row) {
    this.selectData = row;
    this.auditVisible = true;
    this.form.name = row.name;
    this.form.logo = row.logo;
    this.form.id = row.id;

    this.form.auditState = "";
  }


  config.methods.editView = function (row) {
    var data = {};
    data.id = row.id;
    this.$router.push({
      path: 'update',
      query: data
    });

  }

  config.methods.changeTableSort = function (column) {
    this.searchObject.sortField = column.prop;
    if ("descending" == column.order) {
      this.searchObject.sortMethod = "desc";
    } else if ("ascending" == column.order) {
      this.searchObject.sortMethod = "asc";
    } else {
      this.searchObject.sortMethod = "";
    }
    this.getSearchList();
  }
  config.methods.show = function (row) {
    var param = {};
    param.id = row.id;
    this.$router.push({
      path: 'view',
      query: param
    });

  }

  config.methods.handleSelect = function (index) {
    if (index == "1") {
      this.searchObject.auditState = "checked"
    } else if (index == "2") {
      this.searchObject.auditState = "wait"
    } else if (index == "3") {
      this.searchObject.auditState = "fail"
    } else {
      this.searchObject.auditState = ""
    }
    this.activeIndex = index;
    this.getSearchList();
  }

  config.methods.sizeChange = function (event) {
    this.searchObject.size = event;
    this.getSearchList();
  }
  config.methods.pageChange = function (index) {
    this.searchObject.no = index;
    this.getSearchList();
  }
  config.methods.getSearchList = function () {
    this.loading = true;
    var data = this.searchObject;
    var self = this;
    this.postData("/tenantRest/${config_entity}/search.htm", data, function (result) {
      if (result.code == 0) {
        self.tableData = result;
      }
      setTimeout(function () {
        self.loading = false;
      }, 300)
    });
  }
  config.methods.search = function () {
    this.searchObject.no = 1;
    this.getSearchList();
  }
  config.methods.clearData = function () {
    this.searchObject.name = "";
    this.searchObject.address = "";
    this.searchObject.shopState = "";
  }
  config.methods.deleteData = function (event) {
    this.selectId = event.id;
    this.dialogVisible = true;
  }

  config.methods.handleClose = function () {
    this.dialogVisible = false;
    var self = this;
    if (self.selectId) {
      var params = {};
      params.id = self.selectId;
      this.postData("/tenantRest/${config_entity}/delete.htm", params, function (res) {
        if (res.code == 0) {
          self.$message({
            message: '删除数据成功',
            type: 'success'
          });
          self.getSearchList();
        } else {
          self.$message.error(res.msg);
        }
      });
    }

  }

  config.computed = {};

  config.data = function () {
    return {
            searchObject: {
                no: 1,
                size: 10,
                <#if searchs??>
                    <#list searchs as item>
                    ${item.id}:''<#sep>,
                    </#list>
                </#if>
            },
          <#list bean.fields as item>
            <#if item.option?length gt 2 >
              ${item.id}Options: [],
            </#if>
          </#list>
            dialogVisible: false,
            defaultProps: {
                children: 'children',
                label: 'name'
            },
            loading: false,
            tableData: {},
    }
  };
  config.methods.showAddView = function () {
    this.$router.push({
      path: 'add'
    });
  };

  	<#list bean.fields as item>
		<#if item.option?length gt 2 >
		config.methods.load${item.id?cap_first}Options= function(){
				var self=this;
				var param = {};
				param.sortMethod = "asc";
				param.sortField = "id";
				param.level =1;
				param.size =500;
				param.fetch=0;
				this.postData("/tenantRest/${item.id?lower_case}/list.htm", param, function (result) {
					if (result.code == 0) {
              self.${item.id}Options= result.list;
					}
				});
		}

		</#if>
		</#list>


  config.mounted = function () {
    <#list bean.fields as item>
        <#if item.option?length gt 2 >
         this.load${item.id?cap_first}Options();
        </#if>
    </#list>
    this.getSearchList();
  }
  config.mixins = [common];

  export default config;
</script>

<style scoped>

</style>