/*
 * Decompiled with CFR 0.152.
 */
package com.nbsaas.codemake.commands.hibernate;

import com.nbsaas.codemake.commands.base.CodeBaseCommand;
import freemarker.template.Configuration;
import org.apache.commons.chain.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestCommand
extends CodeBaseCommand {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean execute(Context context) throws Exception {
        Boolean restController;
        Boolean tenantRestController;
        boolean isRest = (Boolean)context.get("isRest");
        Configuration config = this.getConfiguration(context);
        Boolean restDomain = (Boolean)context.get("restDomain");
        if (restDomain == null) {
            restDomain = true;
        }
        if ((tenantRestController = (Boolean)context.get("tenantRestController")) == null) {
            tenantRestController = true;
        }
        if ((restController = (Boolean)context.get("restController")) == null) {
            restController = true;
        }
        Boolean restResource = this.getBoolean(context, "restResource", true);
        Boolean restPage = this.getBoolean(context, "restPage", true);
        if (restDomain.booleanValue()) {
            this.handleCode(context, config, "rest_simple", ".api.domain.simple", "Simple");
            this.handleCode(context, config, "rest_response", ".api.domain.response", "Response");
            this.handleCode(context, config, "rest_request_data", ".api.domain.request", "DataRequest");
            this.handleCode(context, config, "rest_request_search", ".api.domain.request", "SearchRequest");
            this.handleCode(context, config, "rest_conver_simple", ".rest.convert", "SimpleConvert");
            this.handleCode(context, config, "rest_conver_response", ".rest.convert", "ResponseConvert");
        }
        if (!isRest) {
            return false;
        }
        this.logger.info("Rest\u63a5\u53e3\u548c\u5b9e\u73b0\u751f\u6210");
        this.handleCode(context, config, "rest_list", ".api.domain.list", "List");
        if (restPage.booleanValue()) {
            this.handleCode(context, config, "rest_page", ".api.domain.page", "Page");
        }
        this.handleCode(context, config, "rest_api", ".api.apis", "Api");
        if (restResource.booleanValue()) {
            this.handleCode(context, config, "rest_resource", ".rest.resource", "Resource");
        }
        if (tenantRestController.booleanValue()) {
            this.handleCode(context, config, "rest_controller_tenant", ".controller.tenant", "TenantRestController");
        }
        if (restController.booleanValue()) {
            this.handleCode(context, config, "rest_controller", ".controller.rest", "RestController");
        }
        return false;
    }
}

