/*
 * Decompiled with CFR 0.152.
 */
package com.naver.speech.clientapi;

import java.util.Locale;

public class SpeechConfig {
    private ServiceType mServiceType;
    private LanguageType mLanguageType;
    private EndPointDetectType mEndPointDetectType;
    private boolean mQuestionDetection;
    private String mExtraInfo;

    public SpeechConfig(ServiceType serviceType, LanguageType languageType, boolean questionDetection, EndPointDetectType endPointDetectType) {
        this.mServiceType = serviceType;
        this.mLanguageType = languageType;
        this.mQuestionDetection = questionDetection;
        this.mEndPointDetectType = endPointDetectType;
        this.mExtraInfo = null;
    }

    public SpeechConfig(ServiceType serviceType, LanguageType languageType, boolean questionDetection, EndPointDetectType endPointDetectType, String server, int port) {
        this.mServiceType = serviceType;
        this.mLanguageType = languageType;
        this.mQuestionDetection = questionDetection;
        this.mEndPointDetectType = endPointDetectType;
        this.mExtraInfo = String.format(Locale.ENGLISH, "%s:%d", server, port);
    }

    public ServiceType getServiceType() {
        return this.mServiceType;
    }

    public void setServiceType(ServiceType serviceType) {
        this.mServiceType = serviceType;
    }

    public LanguageType getLanguageType() {
        return this.mLanguageType;
    }

    public void setLanguageType(LanguageType languageType) {
        this.mLanguageType = languageType;
    }

    public EndPointDetectType getEndPointDetectType() {
        return this.mEndPointDetectType;
    }

    public void setEndPointDetectType(EndPointDetectType endPointDetectType) {
        this.mEndPointDetectType = endPointDetectType;
    }

    public boolean isQuestionDetection() {
        return this.mQuestionDetection;
    }

    public void setQuestionDetection(boolean questionDetection) {
        this.mQuestionDetection = questionDetection;
    }

    public String getExtraInfo() {
        return this.mExtraInfo;
    }

    public void setExtraInfo(String server, int port) {
        this.mExtraInfo = String.format(Locale.ENGLISH, "%s:%d", server, port);
    }

    public static enum EndPointDetectType {
        AUTO(0),
        MANUAL(1),
        HYBRID(2);

        private int epdType;

        private EndPointDetectType(int epdType) {
            this.epdType = epdType;
        }

        public int toInteger() {
            return this.epdType;
        }
    }

    public static enum LanguageType {
        KOREAN(0),
        JAPANESE(1),
        ENGLISH(2),
        CHINESE(3);

        private int languageType;

        private LanguageType(int languageType) {
            this.languageType = languageType;
        }

        int toInteger() {
            return this.languageType;
        }
    }

    public static enum ServiceType {
        WEBSEARCH(0),
        MAPSEARCH(1),
        TRANSTALK(2),
        SHOPPING(3),
        OPENAPI(4),
        JUNIVER(5),
        LIVESEARCH(6),
        MAPNAVI(7),
        PAPAGO(9);

        private int serviceType;

        private ServiceType(int serviceType) {
            this.serviceType = serviceType;
        }

        int toInteger() {
            return this.serviceType;
        }
    }
}

