package com.naver.speech.clientapi;

import java.util.ArrayList;
import java.util.List;

public class SpeechRecognitionResult {

	/**
	 * 남성
	 * @see SpeechRecognitionListener#onResult(SpeechRecognitionResult)
	 */
	public static final int MALE   = 0;
	/**
	 * 여성
	 * @see SpeechRecognitionListener#onResult(SpeechRecognitionResult)
	 */
	public static final int FEMALE = 1;

	private List<String> results;
	private int          gender;
	private int          startFrameIndex;
	private int          endFrameIndex;

	SpeechRecognitionResult(Object[] result) {
		ArrayList<String> results = new ArrayList<String>();
		results.add((String)result[0]);
		results.add((String)result[1]);
		results.add((String)result[2]);
		results.add((String)result[3]);
		results.add((String)result[4]);
		setResults(results);

		setGender(Integer.parseInt((String) result[5]));

		setStartFrameIndex(Integer.parseInt((String) result[6]));
		setEndFrameIndex(Integer.parseInt((String) result[7]));
	}

	/**
	 *
	 * @return 음성인식 최종 결과를 반환합니다. 신뢰도가 높은 순서대로 최대 5개의 후보를 반환합니다.
	 * @see SpeechRecognitionListener#onResult(SpeechRecognitionResult)
	 */
	public List<String> getResults() {
		return results;
	}

	void setResults(List<String> reuslts) {
		this.results = reuslts;
	}

	/**
	 *
	 * @return 해당 발성의 성별 인식 결과를 반환합니다. 남성이면 MALE을, 여성이면 FEMALE을 반환합니다.
	 * @see SpeechRecognitionListener#onResult(SpeechRecognitionResult)
	 */
	public int getGender() {
		return gender;
	}

	void setGender(int gender) {
		this.gender = gender;
	}

	public int getStartFrameIndex() {
		return startFrameIndex;
	}

	void setStartFrameIndex(int startFrameIndex) {
		this.startFrameIndex = startFrameIndex;
	}

	public int getEndFrameIndex() {
		return endFrameIndex;
	}

	void setEndFrameIndex(int endFrameIndex) {
		this.endFrameIndex = endFrameIndex;
	}
}