/*
 * @(#) SpeechRecognitionException.java 2015. 1.
 *
 * Copyright 2015 Naver Corp. All rights Reserved.
 * Naver PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.naver.speech.clientapi;

/**
 * 이 예외는 {@link SpeechRecognizer#recognize(SpeechConfig)} 메소드를 실행하는 도중에 발생한다.
 * 예외가 발생하였다면, 함께 수반되는 메세지를 확인하여 오류를 체크해야 한다.
 * <dl>
 * <dt>Speech Recognizer is already running.</dt>
 * <dd>
 * 음성인식기가 이미 수행 중인 상태에서 중복 실행할 때 발생하는 예외이다.
 * 이 경우 음성인식을 시작하기 전에 수행 여부를 미리 확인하는 것을 추천한다.({@link SpeechRecognizer#isRunning()} 참고)
 * </dd>
 * <dt>LanguageType is null.</dt>
 * <dd>
 * 이 예외는 LanguageType이 초기화되지 않았을 경우 발생한다.
 * </dd>
 * </dl>
 * @see SpeechRecognizer
 */
public class SpeechRecognitionException extends Exception {

	private static final long serialVersionUID = -7118283921758885661L;

	/**
	 * 현재 stack trace에 대한 예외를 발생한다.
	 * 예외에 대한 설명은 {@link SpeechRecognitionException} 을 참조한다.
	 */
	public SpeechRecognitionException() {
		super();
	}

	/**
	 * 현재 stack trace에 대한 예외를 발생한다.
	 * 예외에 대한 설명은 {@link SpeechRecognitionException} 을 참조한다.
	 * @param detailMessage detailMessage 이 예외에 대한 상세 메세지.
	 */
	public SpeechRecognitionException(String detailMessage) {
		super(detailMessage);
	}
}
