package com.naver.speech.clientapi;

import android.content.Context;

public class SpeechFinRecognizer extends SpeechRecognizer {
    /**
     * 금융 음성인식 클라이언트 인스턴스를 생성하고, OpenAPI 인증 작업을 수행합니다.
     *
     * @param context  메인 액티비티의 context
     * @param clientId 개발자센터에서 "내 애플리케이션"을 등록할 때 발급받은 Client ID
     * @throws SpeechRecognitionException 예외가 발생하는 경우는 아래와 같습니다.<br>
     *                                    1. context 파라미터가 올바른 메인 액티비티의 context가 아님<br>
     *                                    2. AndroidManifest.xml에서 package 이름을 올바르게 등록하지 않았음<br>
     *                                    3. package 이름을 올바르게 등록했지만 과도하게 긴 경우(256바이트 이하를 권장)<br>
     *                                    4. clientId 파라미터가 null인 경우<br>
     *                                    개발하면서 예외가 발생하지 않았다면 실서비스에서도 예외는 발생하지 않습니다. 개발 초기에만 주의하시면 됩니다.
     */
    public SpeechFinRecognizer(Context context, String clientId) throws SpeechRecognitionException {
        super(context, clientId, SpeechConfig.DomainType.FIN);
    }

    @Override
    protected int startAudioRecording() {
        return super.startAudioRecording();
    }

    @Override
    protected int stopAudioRecording() {
        return super.stopAudioRecording();
    }

    @Override
    protected short[] record() {
        return super.record();
    }

    @Override
    protected void onInactive() {
        super.onInactive();
    }

    @Override
    protected void onReady() {
        super.onReady();
    }

    @Override
    protected void onRecord(short[] speech) {
        super.onRecord(speech);
    }

    @Override
    protected void onPartialResult(String partialResult) {
        super.onPartialResult(partialResult);
    }

    @Override
    protected void onEndPointDetected() {
        super.onEndPointDetected();
    }

    @Override
    protected void onResult(Object[] finalResult) {
        super.onResult(finalResult);
    }

    @Override
    protected void onError(int errorCode) {
        super.onError(errorCode);
    }

    @Override
    protected void onEndPointDetectTypeSelected(int epdType) {
        super.onEndPointDetectTypeSelected(epdType);
    }
}
