/*
 * Decompiled with CFR 0.152.
 */
package com.naver.speech.clientapi;

import android.content.Context;
import android.os.Build;
import com.naver.speech.clientapi.AudioCapture;
import com.naver.speech.clientapi.SpeechConfig;
import com.naver.speech.clientapi.SpeechRecognitionException;
import com.naver.speech.clientapi.SpeechRecognitionListener;
import com.naver.speech.clientapi.SpeechRecognitionResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SpeechRecognizer {
    protected SpeechRecognitionListener speechRecognitionListener;
    private AudioCapture mAudioCapture = new AudioCapture();
    private Context context;
    private Boolean mIsGov;
    private static final String CLIENT_LIB_VER = "1.1.16";
    public static final int ERROR_NETWORK_INITIALIZE = 10;
    public static final int ERROR_NETWORK_FINALIZE = 11;
    public static final int ERROR_NETWORK_READ = 12;
    public static final int ERROR_NETWORK_WRITE = 13;
    public static final int ERROR_NETWORK_NACK = 14;
    public static final int ERROR_INVALID_PACKET = 15;
    public static final int ERROR_AUDIO_INITIALIZE = 20;
    public static final int ERROR_AUDIO_FINIALIZE = 21;
    public static final int ERROR_AUDIO_RECORD = 22;
    public static final int ERROR_SECURITY = 30;
    public static final int ERROR_INVALID_RESULT = 40;
    public static final int ERROR_TIMEOUT = 41;
    public static final int ERROR_NO_CLIENT_RUNNING = 42;
    public static final int ERROR_UNKOWN_EVENT = 50;
    public static final int ERROR_VERSION = 60;
    public static final int ERROR_CLIENTINFO = 61;
    public static final int ERROR_SERVER_POOL = 62;
    public static final int ERROR_SESSION_EXPIRED = 63;
    public static final int ERROR_SPEECH_SIZE_EXCEEDED = 64;
    public static final int ERROR_EXCEED_TIME_LIMIT = 65;
    public static final int ERROR_WRONG_SERVICE_TYPE = 66;
    public static final int ERROR_WRONG_LANGUAGE_TYPE = 67;
    public static final int ERROR_OPENAPI_AUTH = 70;
    public static final int ERROR_QUOTA_OVERFLOW = 71;

    public SpeechRecognizer(Context context, String clientId) throws SpeechRecognitionException {
        this(context, clientId, false);
    }

    protected SpeechRecognizer(Context context, String clientId, boolean isGov) throws SpeechRecognitionException {
        this.context = context;
        this.mIsGov = isGov;
        String errMsg = SpeechRecognizer.setupJNI(CLIENT_LIB_VER, Build.MODEL, Build.VERSION.RELEASE, clientId, context, this.mIsGov);
        if (errMsg != null) {
            throw new SpeechRecognitionException(errMsg);
        }
    }

    public void initialize() {
        this.initializeJNI();
    }

    public void release() {
        this.releaseJNI();
    }

    public void setSpeechRecognitionListener(SpeechRecognitionListener callback) {
        this.speechRecognitionListener = callback;
    }

    public boolean selectEPDTypeInHybrid(SpeechConfig.EndPointDetectType epdType) {
        return this.selectEPDTypeInHybridJNI(epdType.toInteger());
    }

    public boolean stop() {
        if (this.isRunning()) {
            return this.sendUserEPDJNI();
        }
        return false;
    }

    public boolean cancel() {
        return this.stopListeningJNI();
    }

    public boolean isRunning() {
        return this.isRunningJNI();
    }

    public boolean recognize(SpeechConfig config) throws SpeechRecognitionException {
        if (this.isRunning()) {
            throw new SpeechRecognitionException("Speech Recognizer is already running");
        }
        if (config.getServiceType() == null) {
            throw new SpeechRecognitionException("ServiceType is null");
        }
        if (config.getLanguageType() == null) {
            throw new SpeechRecognitionException("LanguageType is null");
        }
        if (config.getEndPointDetectType() == null) {
            throw new SpeechRecognitionException("LanguageType is null");
        }
        if (config.getLanguageType() == null) {
            throw new SpeechRecognitionException("LanguageType is null");
        }
        if (config.getEndPointDetectType() == null) {
            throw new SpeechRecognitionException("EndPointDetectType is null");
        }
        if (config.getConnectionType() == SpeechConfig.ConnectionType.GRPC_SECURE && !this.setSSLOptions()) {
            throw new SpeechRecognitionException("SSL options is incorrect");
        }
        return this.startListeningJNI(config.getServiceType().toInteger(), config.getLanguageType().toInteger(), config.getCaptureType().toInteger(), config.getWakewordType().toInteger(), config.isQuestionDetection(), config.getEndPointDetectType().toInteger(), config.getConnectionType().toInteger(), config.getExtraInfo(), this.mIsGov);
    }

    private boolean setSSLOptions() {
        if (this.context == null) {
            return false;
        }
        Context ctx = this.context;
        String sslRootsFile = "roots.pem";
        InputStream in = null;
        try {
            int bytesRead;
            in = ctx.getAssets().open(sslRootsFile);
            File outFile = new File(ctx.getExternalFilesDir(null), sslRootsFile);
            FileOutputStream out = new FileOutputStream(outFile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, bytesRead);
            }
            in.close();
            ((OutputStream)out).close();
            SpeechRecognizer.configureSslRoots(outFile.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected int startAudioRecording() {
        try {
            this.mAudioCapture.beforeStart();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    protected int stopAudioRecording() {
        try {
            this.mAudioCapture.beforeFinish();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    protected short[] record() {
        try {
            short[] speech = this.mAudioCapture.record();
            return speech;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void onInactive() {
        if (null != this.speechRecognitionListener) {
            this.speechRecognitionListener.onInactive();
        }
    }

    protected void onReady() {
        if (null != this.speechRecognitionListener) {
            this.speechRecognitionListener.onReady();
        }
    }

    protected void onRecord(short[] speech) {
        if (null != this.speechRecognitionListener) {
            this.speechRecognitionListener.onRecord(speech);
        }
    }

    protected void onPartialResult(String partialResult) {
        if (null != this.speechRecognitionListener) {
            this.speechRecognitionListener.onPartialResult(partialResult);
        }
    }

    protected void onEndPointDetected() {
        if (null != this.speechRecognitionListener) {
            this.speechRecognitionListener.onEndPointDetected();
        }
    }

    protected void onResult(Object[] finalResult) {
        if (null != this.speechRecognitionListener) {
            SpeechRecognitionResult speechRecognitionResult = new SpeechRecognitionResult(finalResult);
            this.speechRecognitionListener.onResult(speechRecognitionResult);
        }
    }

    protected void onError(int errorCode) {
        if (null != this.speechRecognitionListener) {
            this.speechRecognitionListener.onError(errorCode);
        }
    }

    protected void onEndPointDetectTypeSelected(int epdType) {
        if (null != this.speechRecognitionListener) {
            switch (epdType) {
                case 0: {
                    this.speechRecognitionListener.onEndPointDetectTypeSelected(SpeechConfig.EndPointDetectType.AUTO);
                    break;
                }
                case 1: {
                    this.speechRecognitionListener.onEndPointDetectTypeSelected(SpeechConfig.EndPointDetectType.MANUAL);
                    break;
                }
            }
        }
    }

    private static native String setupJNI(String var0, String var1, String var2, String var3, Context var4, boolean var5);

    private native void initializeJNI();

    private native void releaseJNI();

    private native boolean selectEPDTypeInHybridJNI(int var1);

    private native boolean sendUserEPDJNI();

    private native boolean startListeningJNI(int var1, int var2, int var3, int var4, boolean var5, int var6, int var7, String var8, boolean var9);

    private native boolean stopListeningJNI();

    private native boolean isRunningJNI();

    public static native void configureSslRoots(String var0);

    static {
        System.loadLibrary("naverspeech-sdk-c");
    }
}

