/*
 * @(#) AudioCaptureException.java 2015. 1.
 *
 * Copyright 2015 Naver Corp. All rights Reserved.
 * Naver PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.naver.speech.clientapi;

/**
 * 이 예외는 오디오에 관련된 오류를 처리합니다.
 * 가령, 마이크에 접근하지 못하거나 오디오 자원 해제/할당을 너무 빠르게 여러 번 호출할 경우,
 * {@link android.media.AudioRecord} 내부에서 오동작이 발생하게 되는데 이런 오류들을 처리합니다.
 *
 */
public class AudioCaptureException extends Exception {

	private static final long serialVersionUID = -56679720798140245L;

	/**
	 * 현재 stack trace에 대한 예외를 발생시킵니다.
	 * @see AudioCaptureException
	 */
	public AudioCaptureException() {
		super();
	}

	/**
	 * 현재 stack trace에 대한 예외를 발생시킵니다.
	 * @param detailMessage 예외에 대한 상세 메세지
	 * @see AudioCaptureException
	 */
	public AudioCaptureException(String detailMessage) {
		super(detailMessage);
	}
}
