/*
 * Decompiled with CFR 0.152.
 */
package com.natradac.android.tokeninterceptor;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.natradac.android.tokeninterceptor.CannotMapResponseToObject;
import com.natradac.android.tokeninterceptor.ConfigInterceptor;
import com.natradac.android.tokeninterceptor.NotFoundTokenException;
import com.natradac.android.tokeninterceptor.RefreshTokenException;
import com.natradac.android.tokeninterceptor.RefreshTokenExpired;
import com.natradac.android.tokeninterceptor.RefreshTokenManager;
import com.natradac.android.tokeninterceptor.TokenRequestParamType;
import com.natradac.android.tokeninterceptor.db.PreferenceHelper;
import java.io.IOException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001c\u0010\u0010\u001a\u00020\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/natradac/android/tokeninterceptor/ExpiredTokenInterceptor;", "Lokhttp3/Interceptor;", "context", "Landroid/content/Context;", "prefName", "", "(Landroid/content/Context;Ljava/lang/String;)V", "getModifiedRequest", "Lokhttp3/Request;", "oldRequest", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "refreshToken", "", "updateToken", "data", "", "Ljava/lang/Object;", "TokenInterceptor_release"})
public final class ExpiredTokenInterceptor
implements Interceptor {
    private final Context context;
    private final String prefName;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request request = chain.request();
        SharedPreferences pref = PreferenceHelper.INSTANCE.defaultPrefs(this.context, this.prefName);
        try {
            Response response;
            String token = pref.getString("TOKEN", null);
            if (token == null) {
                throw (Throwable)new NotFoundTokenException();
            }
            if (PreferenceHelper.INSTANCE.isAccessTokenExpired(this.context, this.prefName)) {
                if (PreferenceHelper.INSTANCE.isRefreshTokenExpired(this.context, this.prefName)) {
                    throw (Throwable)new RefreshTokenExpired();
                }
                this.refreshToken(chain);
                response = chain.proceed(this.getModifiedRequest(request));
            } else {
                response = chain.proceed(this.getModifiedRequest(request));
            }
            return response;
        }
        catch (Exception e) {
            throw (Throwable)new IOException(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void refreshToken(Interceptor.Chain chain) {
        Request request = RefreshTokenManager.INSTANCE.getRequest(this.context, this.prefName);
        Log.d((String)this.getClass().getName(), (String)(request.method() + " --> " + request.url()));
        Log.d((String)this.getClass().getName(), (String)("Header " + request.headers()));
        Response response = chain.proceed(request);
        Log.d((String)this.getClass().getName(), (String)(" <-- " + response.code() + " " + request.url()));
        if (response.code() != 200) throw (Throwable)new RefreshTokenException("Response code: " + response.code() + ", message: " + response.message());
        if (response.body() == null) throw (Throwable)new RefreshTokenException("Response body: " + response.body());
        Gson gson = new Gson();
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            Intrinsics.throwNpe();
        }
        Object object = gson.fromJson(responseBody.string(), new TypeToken<Map<String, ? extends Object>>(){}.getType());
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Gson().fromJson(\n       \u2026ype\n                    )");
        Map refreshTokenResponse2 = (Map)object;
        Log.d((String)this.getClass().getName(), (String)("body: " + refreshTokenResponse2));
        if (refreshTokenResponse2.get("data") != null) {
            Object v = refreshTokenResponse2.get("data");
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, java.lang.Object>");
            }
            this.updateToken((Map)v);
            return;
        } else if (refreshTokenResponse2.get("datas") != null) {
            Object v = refreshTokenResponse2.get("datas");
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, java.lang.Object>");
            }
            this.updateToken((Map)v);
            return;
        } else {
            if (refreshTokenResponse2 == null) throw (Throwable)new CannotMapResponseToObject();
            this.updateToken(refreshTokenResponse2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateToken(Map<String, ? extends Object> data) {
        String string;
        String key$iv;
        void $this$get$iv22;
        SharedPreferences pref = PreferenceHelper.INSTANCE.defaultPrefs(this.context, this.prefName);
        Map<String, ? extends Object> map = data;
        SharedPreferences sharedPreferences = pref;
        Object object = PreferenceHelper.INSTANCE;
        String string2 = "REFRESH_TOKEN_KEY";
        String defaultValue$iv = "refresh_token";
        boolean $i$f$get = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(String.class);
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            string = $this$get$iv22.getString(key$iv, defaultValue$iv);
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            String string3 = defaultValue$iv;
            if (!(string3 instanceof Integer)) {
                string3 = null;
            }
            Integer n = (Integer)((Object)string3);
            string = (String)((Object)Integer.valueOf($this$get$iv22.getInt(key$iv, n != null ? n : -1)));
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            String string4 = defaultValue$iv;
            if (!(string4 instanceof Boolean)) {
                string4 = null;
            }
            Boolean bl = (Boolean)((Object)string4);
            string = (String)((Object)Boolean.valueOf($this$get$iv22.getBoolean(key$iv, bl != null ? bl : false)));
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            String string5 = defaultValue$iv;
            if (!(string5 instanceof Float)) {
                string5 = null;
            }
            Float f = (Float)((Object)string5);
            string = (String)((Object)Float.valueOf($this$get$iv22.getFloat(key$iv, f != null ? f.floatValue() : -1.0f)));
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            String string6 = defaultValue$iv;
            if (!(string6 instanceof Long)) {
                string6 = null;
            }
            Long l = (Long)((Object)string6);
            string = (String)((Object)Long.valueOf($this$get$iv22.getLong(key$iv, l != null ? l : -1L)));
        } else {
            throw (Throwable)new UnsupportedOperationException("Not yet implemented");
        }
        object = string;
        boolean $this$get$iv22 = false;
        if (map.get(object) != null) {
            String string7;
            map = data;
            SharedPreferences $this$get$iv22 = pref;
            object = PreferenceHelper.INSTANCE;
            key$iv = "TOKEN_KEY";
            defaultValue$iv = "access_token";
            $i$f$get = false;
            kClass = Reflection.getOrCreateKotlinClass(String.class);
            if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                string7 = $this$get$iv22.getString(key$iv, defaultValue$iv);
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                String string8 = defaultValue$iv;
                if (!(string8 instanceof Integer)) {
                    string8 = null;
                }
                Integer n = (Integer)((Object)string8);
                string7 = (String)((Object)Integer.valueOf($this$get$iv22.getInt(key$iv, n != null ? n : -1)));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                String string9 = defaultValue$iv;
                if (!(string9 instanceof Boolean)) {
                    string9 = null;
                }
                Boolean bl = (Boolean)((Object)string9);
                string7 = (String)((Object)Boolean.valueOf($this$get$iv22.getBoolean(key$iv, bl != null ? bl : false)));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                String string10 = defaultValue$iv;
                if (!(string10 instanceof Float)) {
                    string10 = null;
                }
                Float f = (Float)((Object)string10);
                string7 = (String)((Object)Float.valueOf($this$get$iv22.getFloat(key$iv, f != null ? f.floatValue() : -1.0f)));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                String string11 = defaultValue$iv;
                if (!(string11 instanceof Long)) {
                    string11 = null;
                }
                Long l = (Long)((Object)string11);
                string7 = (String)((Object)Long.valueOf($this$get$iv22.getLong(key$iv, l != null ? l : -1L)));
            } else {
                throw (Throwable)new UnsupportedOperationException("Not yet implemented");
            }
            object = string7;
            boolean $this$get$iv232 = false;
            if (map.get(object) != null) {
                String string12;
                map = data;
                SharedPreferences $this$get$iv232 = pref;
                object = PreferenceHelper.INSTANCE;
                key$iv = "ACCESS_VALID_KEY";
                defaultValue$iv = "access_valid";
                $i$f$get = false;
                kClass = Reflection.getOrCreateKotlinClass(String.class);
                if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    string12 = $this$get$iv232.getString(key$iv, defaultValue$iv);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    String string13 = defaultValue$iv;
                    if (!(string13 instanceof Integer)) {
                        string13 = null;
                    }
                    Integer n = (Integer)((Object)string13);
                    string12 = (String)((Object)Integer.valueOf($this$get$iv232.getInt(key$iv, n != null ? n : -1)));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    String string14 = defaultValue$iv;
                    if (!(string14 instanceof Boolean)) {
                        string14 = null;
                    }
                    Boolean bl = (Boolean)((Object)string14);
                    string12 = (String)((Object)Boolean.valueOf($this$get$iv232.getBoolean(key$iv, bl != null ? bl : false)));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                    String string15 = defaultValue$iv;
                    if (!(string15 instanceof Float)) {
                        string15 = null;
                    }
                    Float f = (Float)((Object)string15);
                    string12 = (String)((Object)Float.valueOf($this$get$iv232.getFloat(key$iv, f != null ? f.floatValue() : -1.0f)));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    String string16 = defaultValue$iv;
                    if (!(string16 instanceof Long)) {
                        string16 = null;
                    }
                    Long l = (Long)((Object)string16);
                    string12 = (String)((Object)Long.valueOf($this$get$iv232.getLong(key$iv, l != null ? l : -1L)));
                } else {
                    throw (Throwable)new UnsupportedOperationException("Not yet implemented");
                }
                object = string12;
                boolean $this$get$iv32 = false;
                if (map.get(object) != null) {
                    String string17;
                    map = data;
                    SharedPreferences $this$get$iv32 = pref;
                    object = PreferenceHelper.INSTANCE;
                    key$iv = "REFRESH_VALID_KEY";
                    defaultValue$iv = "refresh_valid";
                    $i$f$get = false;
                    kClass = Reflection.getOrCreateKotlinClass(String.class);
                    if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                        string17 = $this$get$iv32.getString(key$iv, defaultValue$iv);
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                        String string18 = defaultValue$iv;
                        if (!(string18 instanceof Integer)) {
                            string18 = null;
                        }
                        Integer n = (Integer)((Object)string18);
                        string17 = (String)((Object)Integer.valueOf($this$get$iv32.getInt(key$iv, n != null ? n : -1)));
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                        String string19 = defaultValue$iv;
                        if (!(string19 instanceof Boolean)) {
                            string19 = null;
                        }
                        Boolean bl = (Boolean)((Object)string19);
                        string17 = (String)((Object)Boolean.valueOf($this$get$iv32.getBoolean(key$iv, bl != null ? bl : false)));
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                        String string20 = defaultValue$iv;
                        if (!(string20 instanceof Float)) {
                            string20 = null;
                        }
                        Float f = (Float)((Object)string20);
                        string17 = (String)((Object)Float.valueOf($this$get$iv32.getFloat(key$iv, f != null ? f.floatValue() : -1.0f)));
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                        String string21 = defaultValue$iv;
                        if (!(string21 instanceof Long)) {
                            string21 = null;
                        }
                        Long l = (Long)((Object)string21);
                        string17 = (String)((Object)Long.valueOf($this$get$iv32.getLong(key$iv, l != null ? l : -1L)));
                    } else {
                        throw (Throwable)new UnsupportedOperationException("Not yet implemented");
                    }
                    object = string17;
                    boolean $this$get$iv332 = false;
                    if (map.get(object) != null) {
                        Object object2;
                        String string22;
                        Object object3;
                        String string23;
                        Object object4;
                        String string24;
                        Object object5;
                        String string25;
                        map = data;
                        SharedPreferences $this$get$iv332 = pref;
                        object = PreferenceHelper.INSTANCE;
                        key$iv = "TOKEN_KEY";
                        defaultValue$iv = "access_token";
                        String string26 = this.prefName;
                        Context context = this.context;
                        RefreshTokenManager refreshTokenManager = RefreshTokenManager.INSTANCE;
                        $i$f$get = false;
                        kClass = Reflection.getOrCreateKotlinClass(String.class);
                        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                            string25 = $this$get$iv332.getString(key$iv, defaultValue$iv);
                        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                            String string27 = defaultValue$iv;
                            if (!(string27 instanceof Integer)) {
                                string27 = null;
                            }
                            Integer n = (Integer)((Object)string27);
                            string25 = (String)((Object)Integer.valueOf($this$get$iv332.getInt(key$iv, n != null ? n : -1)));
                        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                            String string28 = defaultValue$iv;
                            if (!(string28 instanceof Boolean)) {
                                string28 = null;
                            }
                            Boolean bl = (Boolean)((Object)string28);
                            string25 = (String)((Object)Boolean.valueOf($this$get$iv332.getBoolean(key$iv, bl != null ? bl : false)));
                        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                            String string29 = defaultValue$iv;
                            if (!(string29 instanceof Float)) {
                                string29 = null;
                            }
                            Float f = (Float)((Object)string29);
                            string25 = (String)((Object)Float.valueOf($this$get$iv332.getFloat(key$iv, f != null ? f.floatValue() : -1.0f)));
                        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                            String string30 = defaultValue$iv;
                            if (!(string30 instanceof Long)) {
                                string30 = null;
                            }
                            Long l = (Long)((Object)string30);
                            string25 = (String)((Object)Long.valueOf($this$get$iv332.getLong(key$iv, l != null ? l : -1L)));
                        } else {
                            throw (Throwable)new UnsupportedOperationException("Not yet implemented");
                        }
                        object = object5 = string25;
                        boolean $this$get$iv42 = false;
                        object5 = map.get(object);
                        map = data;
                        SharedPreferences $this$get$iv42 = pref;
                        object = PreferenceHelper.INSTANCE;
                        key$iv = "REFRESH_TOKEN_KEY";
                        defaultValue$iv = "refresh_token";
                        object5 = String.valueOf(object5);
                        $i$f$get = false;
                        kClass = Reflection.getOrCreateKotlinClass(String.class);
                        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                            string24 = $this$get$iv42.getString(key$iv, defaultValue$iv);
                        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                            String string31 = defaultValue$iv;
                            if (!(string31 instanceof Integer)) {
                                string31 = null;
                            }
                            Integer n = (Integer)((Object)string31);
                            string24 = (String)((Object)Integer.valueOf($this$get$iv42.getInt(key$iv, n != null ? n : -1)));
                        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                            String string32 = defaultValue$iv;
                            if (!(string32 instanceof Boolean)) {
                                string32 = null;
                            }
                            Boolean bl = (Boolean)((Object)string32);
                            string24 = (String)((Object)Boolean.valueOf($this$get$iv42.getBoolean(key$iv, bl != null ? bl : false)));
                        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                            String string33 = defaultValue$iv;
                            if (!(string33 instanceof Float)) {
                                string33 = null;
                            }
                            Float f = (Float)((Object)string33);
                            string24 = (String)((Object)Float.valueOf($this$get$iv42.getFloat(key$iv, f != null ? f.floatValue() : -1.0f)));
                        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                            String string34 = defaultValue$iv;
                            if (!(string34 instanceof Long)) {
                                string34 = null;
                            }
                            Long l = (Long)((Object)string34);
                            string24 = (String)((Object)Long.valueOf($this$get$iv42.getLong(key$iv, l != null ? l : -1L)));
                        } else {
                            throw (Throwable)new UnsupportedOperationException("Not yet implemented");
                        }
                        object = object4 = string24;
                        $this$get$iv5 = false;
                        object4 = map.get(object);
                        map = data;
                        SharedPreferences $this$get$iv5 = pref;
                        object = PreferenceHelper.INSTANCE;
                        key$iv = "ACCESS_VALID_KEY";
                        defaultValue$iv = "access_valid";
                        object4 = String.valueOf(object4);
                        $i$f$get = false;
                        kClass = Reflection.getOrCreateKotlinClass(String.class);
                        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                            string23 = $this$get$iv5.getString(key$iv, defaultValue$iv);
                        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                            String string35 = defaultValue$iv;
                            if (!(string35 instanceof Integer)) {
                                string35 = null;
                            }
                            Integer n = (Integer)((Object)string35);
                            string23 = (String)((Object)Integer.valueOf($this$get$iv5.getInt(key$iv, n != null ? n : -1)));
                        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                            String string36 = defaultValue$iv;
                            if (!(string36 instanceof Boolean)) {
                                string36 = null;
                            }
                            Boolean bl = (Boolean)((Object)string36);
                            string23 = (String)((Object)Boolean.valueOf($this$get$iv5.getBoolean(key$iv, bl != null ? bl : false)));
                        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                            String string37 = defaultValue$iv;
                            if (!(string37 instanceof Float)) {
                                string37 = null;
                            }
                            Float f = (Float)((Object)string37);
                            string23 = (String)((Object)Float.valueOf($this$get$iv5.getFloat(key$iv, f != null ? f.floatValue() : -1.0f)));
                        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                            String string38 = defaultValue$iv;
                            if (!(string38 instanceof Long)) {
                                string38 = null;
                            }
                            Long l = (Long)((Object)string38);
                            string23 = (String)((Object)Long.valueOf($this$get$iv5.getLong(key$iv, l != null ? l : -1L)));
                        } else {
                            throw (Throwable)new UnsupportedOperationException("Not yet implemented");
                        }
                        object = object3 = string23;
                        $this$get$iv6 = false;
                        Object object6 = object3 = map.get(object);
                        if (object6 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Double");
                        }
                        map = data;
                        SharedPreferences $this$get$iv6 = pref;
                        object = PreferenceHelper.INSTANCE;
                        key$iv = "REFRESH_VALID_KEY";
                        defaultValue$iv = "refresh_valid";
                        long l = (long)((Double)object6).doubleValue();
                        $i$f$get = false;
                        kClass = Reflection.getOrCreateKotlinClass(String.class);
                        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                            string22 = $this$get$iv6.getString(key$iv, defaultValue$iv);
                        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                            String string39 = defaultValue$iv;
                            if (!(string39 instanceof Integer)) {
                                string39 = null;
                            }
                            Integer n = (Integer)((Object)string39);
                            string22 = (String)((Object)Integer.valueOf($this$get$iv6.getInt(key$iv, n != null ? n : -1)));
                        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                            String string40 = defaultValue$iv;
                            if (!(string40 instanceof Boolean)) {
                                string40 = null;
                            }
                            Boolean bl = (Boolean)((Object)string40);
                            string22 = (String)((Object)Boolean.valueOf($this$get$iv6.getBoolean(key$iv, bl != null ? bl : false)));
                        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                            String string41 = defaultValue$iv;
                            if (!(string41 instanceof Float)) {
                                string41 = null;
                            }
                            Float f = (Float)((Object)string41);
                            string22 = (String)((Object)Float.valueOf($this$get$iv6.getFloat(key$iv, f != null ? f.floatValue() : -1.0f)));
                        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                            String string42 = defaultValue$iv;
                            if (!(string42 instanceof Long)) {
                                string42 = null;
                            }
                            Long l2 = (Long)((Object)string42);
                            string22 = (String)((Object)Long.valueOf($this$get$iv6.getLong(key$iv, l2 != null ? l2 : -1L)));
                        } else {
                            throw (Throwable)new UnsupportedOperationException("Not yet implemented");
                        }
                        object = object2 = string22;
                        boolean bl = false;
                        Object object7 = object2 = map.get(object);
                        if (object7 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Double");
                        }
                        refreshTokenManager.updateToken(context, string26, (String)object5, (String)object4, l, (long)((Double)object7).doubleValue());
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Request getModifiedRequest(Request oldRequest) {
        SharedPreferences pref = PreferenceHelper.INSTANCE.defaultPrefs(this.context, this.prefName);
        TokenRequestParamType tokenRequestParamType = ConfigInterceptor.INSTANCE.getTokenParamType();
        if (Intrinsics.areEqual((Object)tokenRequestParamType, (Object)TokenRequestParamType.Query.INSTANCE)) {
            String string;
            void defaultValue$iv;
            void key$iv;
            void $this$get$iv;
            SharedPreferences sharedPreferences = pref;
            PreferenceHelper preferenceHelper = PreferenceHelper.INSTANCE;
            String string2 = "TOKEN";
            String string3 = "";
            String string4 = ConfigInterceptor.INSTANCE.getTokenKey();
            HttpUrl.Builder builder = oldRequest.url().newBuilder();
            boolean $i$f$get = false;
            KClass kClass = Reflection.getOrCreateKotlinClass(String.class);
            if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                string = $this$get$iv.getString((String)key$iv, (String)defaultValue$iv);
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                Object v1 = defaultValue$iv;
                if (!(v1 instanceof Integer)) {
                    v1 = null;
                }
                Integer n = v1;
                string = (String)((Object)Integer.valueOf($this$get$iv.getInt((String)key$iv, n != null ? n : -1)));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                Object v3 = defaultValue$iv;
                if (!(v3 instanceof Boolean)) {
                    v3 = null;
                }
                Boolean bl = v3;
                string = (String)((Object)Boolean.valueOf($this$get$iv.getBoolean((String)key$iv, bl != null ? bl : false)));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                Object v5 = defaultValue$iv;
                if (!(v5 instanceof Float)) {
                    v5 = null;
                }
                Float f = v5;
                string = (String)((Object)Float.valueOf($this$get$iv.getFloat((String)key$iv, f != null ? f.floatValue() : -1.0f)));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                Object v7 = defaultValue$iv;
                if (!(v7 instanceof Long)) {
                    v7 = null;
                }
                Long l = v7;
                string = (String)((Object)Long.valueOf($this$get$iv.getLong((String)key$iv, l != null ? l : -1L)));
            } else {
                throw (Throwable)new UnsupportedOperationException("Not yet implemented");
            }
            String string5 = string;
            HttpUrl url = builder.addQueryParameter(string4, String.valueOf(string5)).build();
            Request newRequest = oldRequest.newBuilder().url(url).build();
            Log.d((String)this.getClass().getName(), (String)(newRequest.method() + " --> " + newRequest.url()));
            Log.d((String)this.getClass().getName(), (String)("Header " + newRequest.headers().toString()));
            return newRequest;
        }
        if (Intrinsics.areEqual((Object)tokenRequestParamType, (Object)TokenRequestParamType.Header.INSTANCE)) {
            String string;
            SharedPreferences $this$get$iv = pref;
            PreferenceHelper preferenceHelper = PreferenceHelper.INSTANCE;
            String key$iv = "TOKEN";
            String defaultValue$iv = "";
            String string6 = ConfigInterceptor.INSTANCE.getTokenKey();
            Request.Builder builder = oldRequest.newBuilder();
            boolean $i$f$get = false;
            KClass kClass = Reflection.getOrCreateKotlinClass(String.class);
            if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                string = $this$get$iv.getString(key$iv, defaultValue$iv);
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                String string7 = defaultValue$iv;
                if (!(string7 instanceof Integer)) {
                    string7 = null;
                }
                Integer n = (Integer)((Object)string7);
                string = (String)((Object)Integer.valueOf($this$get$iv.getInt(key$iv, n != null ? n : -1)));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                String string8 = defaultValue$iv;
                if (!(string8 instanceof Boolean)) {
                    string8 = null;
                }
                Boolean bl = (Boolean)((Object)string8);
                string = (String)((Object)Boolean.valueOf($this$get$iv.getBoolean(key$iv, bl != null ? bl : false)));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                String string9 = defaultValue$iv;
                if (!(string9 instanceof Float)) {
                    string9 = null;
                }
                Float f = (Float)((Object)string9);
                string = (String)((Object)Float.valueOf($this$get$iv.getFloat(key$iv, f != null ? f.floatValue() : -1.0f)));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                String string10 = defaultValue$iv;
                if (!(string10 instanceof Long)) {
                    string10 = null;
                }
                Long l = (Long)((Object)string10);
                string = (String)((Object)Long.valueOf($this$get$iv.getLong(key$iv, l != null ? l : -1L)));
            } else {
                throw (Throwable)new UnsupportedOperationException("Not yet implemented");
            }
            String string11 = string;
            Request newRequest = builder.addHeader(string6, String.valueOf(string11)).build();
            Log.d((String)this.getClass().getName(), (String)(newRequest.method() + " --> " + newRequest.url()));
            Log.d((String)this.getClass().getName(), (String)("Header " + newRequest.headers().toString()));
            return newRequest;
        }
        Log.d((String)this.getClass().getName(), (String)(oldRequest.method() + " --> " + oldRequest.url()));
        Log.d((String)this.getClass().getName(), (String)("Header " + oldRequest.headers().toString()));
        return oldRequest;
    }

    public ExpiredTokenInterceptor(@NotNull Context context, @NotNull String prefName) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)prefName, (String)"prefName");
        this.context = context;
        this.prefName = prefName;
    }
}

