/*
 * Decompiled with CFR 0.152.
 */
package com.natradac.android.tokeninterceptor;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.google.gson.Gson;
import com.natradac.android.tokeninterceptor.NotFoundTokenException;
import com.natradac.android.tokeninterceptor.RefreshToken;
import com.natradac.android.tokeninterceptor.RefreshTokenException;
import com.natradac.android.tokeninterceptor.db.PreferenceHelper;
import com.natradac.android.tokeninterceptor.model.RefreshTokenRequest;
import com.natradac.android.tokeninterceptor.model.RefreshTokenResponse;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/natradac/android/tokeninterceptor/ExpiredTokenInterceptor;", "Lokhttp3/Interceptor;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "refreshToken", "", "token", "", "TokenInterceptor_release"})
public final class ExpiredTokenInterceptor
implements Interceptor {
    private final Context context;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request request = chain.request();
        SharedPreferences pref = PreferenceHelper.INSTANCE.defaultPrefs(this.context);
        try {
            String token = pref.getString("TOKEN", null);
            if (token == null) {
                throw (Throwable)new NotFoundTokenException();
            }
            if (PreferenceHelper.INSTANCE.isTokenExpired(this.context)) {
                String string;
                String defaultValue$iv;
                SharedPreferences key$iv;
                PreferenceHelper $this$get$iv;
                Log.i((String)"TokenInterceptor", (String)"Token is expired");
                SharedPreferences sharedPreferences = pref;
                PreferenceHelper preferenceHelper = PreferenceHelper.INSTANCE;
                String string2 = "REFRESH_TOKEN";
                String string3 = "";
                String string4 = token;
                ExpiredTokenInterceptor expiredTokenInterceptor = this;
                boolean $i$f$get2 = false;
                KClass kClass = Reflection.getOrCreateKotlinClass(String.class);
                if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    string = $this$get$iv.getString((String)key$iv, defaultValue$iv);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    String string5 = defaultValue$iv;
                    if (!(string5 instanceof Integer)) {
                        string5 = null;
                    }
                    Integer n = (Integer)((Object)string5);
                    string = (String)((Object)Integer.valueOf($this$get$iv.getInt((String)key$iv, n != null ? n : -1)));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    String string6 = defaultValue$iv;
                    if (!(string6 instanceof Boolean)) {
                        string6 = null;
                    }
                    Boolean bl = (Boolean)((Object)string6);
                    string = (String)((Object)Boolean.valueOf($this$get$iv.getBoolean((String)key$iv, bl != null ? bl : false)));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                    String string7 = defaultValue$iv;
                    if (!(string7 instanceof Float)) {
                        string7 = null;
                    }
                    Float f = (Float)((Object)string7);
                    string = (String)((Object)Float.valueOf($this$get$iv.getFloat((String)key$iv, f != null ? f.floatValue() : -1.0f)));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    String string8 = defaultValue$iv;
                    if (!(string8 instanceof Long)) {
                        string8 = null;
                    }
                    Long l = (Long)((Object)string8);
                    string = (String)((Object)Long.valueOf($this$get$iv.getLong((String)key$iv, l != null ? l : -1L)));
                } else {
                    throw (Throwable)new UnsupportedOperationException("Not yet implemented");
                }
                String string9 = string;
                boolean result = expiredTokenInterceptor.refreshToken(string4, String.valueOf(string9), chain);
                if (result) {
                    String string10;
                    void defaultValue$iv2;
                    void key$iv2;
                    void $this$get$iv2;
                    key$iv = pref;
                    $this$get$iv = PreferenceHelper.INSTANCE;
                    defaultValue$iv = "TOKEN";
                    String $i$f$get2 = "";
                    string4 = "Authorization";
                    expiredTokenInterceptor = request.newBuilder();
                    boolean $i$f$get3 = false;
                    KClass kClass2 = Reflection.getOrCreateKotlinClass(String.class);
                    if (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                        string10 = $this$get$iv2.getString((String)key$iv2, (String)defaultValue$iv2);
                    } else if (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                        Object v10 = defaultValue$iv2;
                        if (!(v10 instanceof Integer)) {
                            v10 = null;
                        }
                        Integer n = v10;
                        string10 = (String)((Object)Integer.valueOf($this$get$iv2.getInt((String)key$iv2, n != null ? n : -1)));
                    } else if (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                        Object v12 = defaultValue$iv2;
                        if (!(v12 instanceof Boolean)) {
                            v12 = null;
                        }
                        Boolean bl = v12;
                        string10 = (String)((Object)Boolean.valueOf($this$get$iv2.getBoolean((String)key$iv2, bl != null ? bl : false)));
                    } else if (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                        Object v14 = defaultValue$iv2;
                        if (!(v14 instanceof Float)) {
                            v14 = null;
                        }
                        Float f = v14;
                        string10 = (String)((Object)Float.valueOf($this$get$iv2.getFloat((String)key$iv2, f != null ? f.floatValue() : -1.0f)));
                    } else if (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                        Object v16 = defaultValue$iv2;
                        if (!(v16 instanceof Long)) {
                            v16 = null;
                        }
                        Long l = v16;
                        string10 = (String)((Object)Long.valueOf($this$get$iv2.getLong((String)key$iv2, l != null ? l : -1L)));
                    } else {
                        throw (Throwable)new UnsupportedOperationException("Not yet implemented");
                    }
                    string9 = string10;
                    Request modifiedRequest = expiredTokenInterceptor.addHeader(string4, String.valueOf(string9)).build();
                    return chain.proceed(modifiedRequest);
                }
                throw (Throwable)new RefreshTokenException();
            }
            Request modifiedRequest = request.newBuilder().addHeader("Authorization", token).build();
            return chain.proceed(modifiedRequest);
        }
        catch (Exception e) {
            throw (Throwable)new IOException(e.getMessage());
        }
    }

    private final boolean refreshToken(String token, String refreshToken, Interceptor.Chain chain) {
        boolean bl;
        String requestBody = new Gson().toJson((Object)new RefreshTokenRequest(token, refreshToken));
        Request.Builder builder = new Request.Builder();
        String string = requestBody;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"requestBody");
        Request refreshTokenRequest = builder.method("POST", RequestBody.Companion.create(string, MediaType.Companion.parse("application/json"))).url(RefreshToken.INSTANCE.getEndpoint()).build();
        Response response = chain.proceed(refreshTokenRequest);
        if (response.body() != null) {
            Gson gson = new Gson();
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                Intrinsics.throwNpe();
            }
            RefreshTokenResponse refreshTokenResponse = (RefreshTokenResponse)gson.fromJson(responseBody.string(), RefreshTokenResponse.class);
            RefreshToken.INSTANCE.updateToken(refreshTokenResponse.getAccess_token(), refreshTokenResponse.getRefresh_token(), refreshTokenResponse.getExpires_in());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public ExpiredTokenInterceptor(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

