/*
 * Decompiled with CFR 0.152.
 */
package com.jnaerator;

import com.ochafik.lang.jnaerator.JNAerator;
import com.ochafik.lang.jnaerator.JNAeratorConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class JNAeratorMojo
extends AbstractMojo {
    private File config;
    private boolean generateScala;
    private File javaOutputDirectory;
    private File scalaOutputDirectory;
    private MavenProject project;

    static File canonizeDir(File f) throws IOException {
        if (!f.exists()) {
            f.mkdirs();
        }
        return f.getCanonicalFile();
    }

    public void execute() throws MojoExecutionException {
        if (!this.config.exists()) {
            this.getLog().info((CharSequence)("No JNAerator config file '" + this.config + "' found"));
            return;
        }
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.config.getAbsolutePath());
            args.add("-mode");
            args.add(JNAeratorConfig.OutputMode.Directory.name());
            args.add("-f");
            args.add("-o");
            File javaDir = JNAeratorMojo.canonizeDir(this.javaOutputDirectory);
            args.add(javaDir.toString());
            this.project.addCompileSourceRoot(javaDir.toString());
            if (this.generateScala) {
                args.add("-scalaOut");
                args.add(JNAeratorMojo.canonizeDir(this.scalaOutputDirectory).toString());
            }
            JNAerator.main((String[])args.toArray(new String[0]));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error running JNAerator on " + this.config, e);
        }
    }
}

