package ir.najva.najvasdk.reactnativeplugin;


import android.util.Log;

import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.najva.sdk.Najva;
import com.najva.sdk.NajvaClient;
import com.najva.sdk.NajvaConfiguration;
import com.najva.sdk.NajvaJsonDataListener;
import com.najva.sdk.NotificationClickListener;
import com.najva.sdk.NotificationReceiveListener;
import com.najva.sdk.UserSubscriptionListener;


import javax.annotation.Nonnull;

public class InitializeModule extends ReactContextBaseJavaModule {

    private static final String HANDLER_EVENT_NAME = "userHandler";
    private static final String DATA_EVENT_NAME = "data";
    private ReactApplicationContext reactContext;

    public InitializeModule(@Nonnull ReactApplicationContext reactContext) {
        super(reactContext);

        this.reactContext = reactContext;
    }

    @Nonnull
    @Override
    public String getName() {
        return "NajvaModule";
    }

    @ReactMethod
    public void initializeNajva(boolean isLocationEnabled) {

        NajvaConfiguration configuration = new NajvaConfiguration();
        if (isLocationEnabled)
            configuration.enableLocation();
        else
            configuration.disableLocation();


        configuration.setUserSubscriptionListener(new UserSubscriptionListener() {
            @Override
            public void onUserSubscribed(String token) {
                reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)
                        .emit(HANDLER_EVENT_NAME, token);
            }
        });

        configuration.setNajvaJsonDataListener(new NajvaJsonDataListener() {
            @Override
            public void onReceiveJson(String jsonString) {
                reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)
                        .emit(DATA_EVENT_NAME, jsonString);
            }
        });

        if (getCurrentActivity() != null) {
            getCurrentActivity().getApplication().registerActivityLifecycleCallbacks(NajvaClient.getInstance(reactContext, configuration));
        }
        Log.d("NAJVA_INIT", "initialize: " + getCurrentActivity() + ", " + configuration);

    }

    @ReactMethod
    public void setReceiveNotificationListener(final Callback callback) {
        NajvaClient.configuration.setReceiveNotificationListener(new NotificationReceiveListener() {
            @Override
            public void onReceiveNotification(String notificationId) {
                Log.d("NAJVA_INIT", "onReceiveNotification: " + notificationId);
                callback.invoke(notificationId);
            }
        });
    }

    @ReactMethod void setNotificationClickListener(final Callback callback){
        NajvaClient.configuration.setNotificationClickListener(new NotificationClickListener() {
            @Override
            public void onClickNotification(String notificationId, int buttonId) {
                Log.d("NAJVA_INIT", "onNotificationClick: " + notificationId + " - " + buttonId);
                callback.invoke(notificationId,buttonId);
            }
        });
    }

    @ReactMethod
    public void getSubscribedToken(Callback callback) {
         callback.invoke(NajvaClient.getInstance().getSubscribedToken());
    }
}
