/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.support;

import com.mysema.query.sql.support.ForeignKeyData;
import com.mysema.query.sql.support.InverseForeignKeyData;
import com.mysema.query.sql.support.PrimaryKeyData;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class KeyDataFactory {
    private static final int FK_FOREIGN_COLUMN_NAME = 8;
    private static final int FK_FOREIGN_TABLE_NAME = 7;
    private static final int FK_NAME = 12;
    private static final int FK_PARENT_COLUMN_NAME = 4;
    private static final int FK_PARENT_TABLE_NAME = 3;
    private static final int PK_COLUMN_NAME = 4;
    private static final int PK_NAME = 6;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, InverseForeignKeyData> getExportedKeys(DatabaseMetaData md, String schemaPattern, String tableName) throws SQLException {
        ResultSet foreignKeys = md.getExportedKeys(null, schemaPattern, tableName);
        HashMap<String, InverseForeignKeyData> inverseForeignKeyData = new HashMap<String, InverseForeignKeyData>();
        try {
            while (foreignKeys.next()) {
                String name = foreignKeys.getString(12);
                String parentColumnName = foreignKeys.getString(4);
                String foreignTableName = foreignKeys.getString(7);
                String foreignColumn = foreignKeys.getString(8);
                InverseForeignKeyData data = (InverseForeignKeyData)inverseForeignKeyData.get(name);
                if (data == null) {
                    data = new InverseForeignKeyData(name, foreignTableName);
                    inverseForeignKeyData.put(name, data);
                }
                data.add(parentColumnName, foreignColumn);
            }
            HashMap<String, InverseForeignKeyData> hashMap = inverseForeignKeyData;
            return hashMap;
        }
        finally {
            foreignKeys.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ForeignKeyData> getImportedKeys(DatabaseMetaData md, String schemaPattern, String tableName) throws SQLException {
        ResultSet foreignKeys = md.getImportedKeys(null, schemaPattern, tableName);
        HashMap<String, ForeignKeyData> foreignKeyData = new HashMap<String, ForeignKeyData>();
        try {
            while (foreignKeys.next()) {
                String name = foreignKeys.getString(12);
                String parentTableName = foreignKeys.getString(3);
                String parentColumnName = foreignKeys.getString(4);
                String foreignColumn = foreignKeys.getString(8);
                ForeignKeyData data = (ForeignKeyData)foreignKeyData.get(name);
                if (data == null) {
                    data = new ForeignKeyData(name, parentTableName);
                    foreignKeyData.put(name, data);
                }
                data.add(foreignColumn, parentColumnName);
            }
            HashMap<String, ForeignKeyData> hashMap = foreignKeyData;
            return hashMap;
        }
        finally {
            foreignKeys.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PrimaryKeyData> getPrimaryKeys(DatabaseMetaData md, String schemaPattern, String tableName) throws SQLException {
        ResultSet primaryKeys = md.getPrimaryKeys(null, schemaPattern, tableName);
        HashMap<String, PrimaryKeyData> primaryKeyData = new HashMap<String, PrimaryKeyData>();
        try {
            while (primaryKeys.next()) {
                String name = primaryKeys.getString(6);
                String columnName = primaryKeys.getString(4);
                PrimaryKeyData data = (PrimaryKeyData)primaryKeyData.get(name);
                if (data == null) {
                    data = new PrimaryKeyData(name);
                    primaryKeyData.put(name, data);
                }
                data.add(columnName);
            }
            HashMap<String, PrimaryKeyData> hashMap = primaryKeyData;
            return hashMap;
        }
        finally {
            primaryKeys.close();
        }
    }
}

