/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.oracle;

import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.sql.AbstractSQLQuery;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.OracleTemplates;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.types.Expr;
import com.mysema.query.types.expr.EBoolean;
import java.sql.Connection;

public class OracleQuery
extends AbstractSQLQuery<OracleQuery> {
    private static final String CONNECT_BY = "\nconnect by ";
    private static final String CONNECT_BY_NOCYCLE_PRIOR = "\nconnect by nocycle prior ";
    private static final String CONNECT_BY_PRIOR = "\nconnect by prior ";
    private static final String ORDER_SIBLINGS_BY = "\norder siblings by ";
    private static final String START_WITH = "\nstart with ";

    public OracleQuery(Connection conn) {
        this(conn, new OracleTemplates(), (QueryMetadata)new DefaultQueryMetadata());
    }

    public OracleQuery(Connection conn, SQLTemplates templates) {
        this(conn, templates, (QueryMetadata)new DefaultQueryMetadata());
    }

    protected OracleQuery(Connection conn, SQLTemplates templates, QueryMetadata metadata) {
        super(conn, new Configuration(templates), metadata);
    }

    public OracleQuery connectByPrior(EBoolean cond) {
        return (OracleQuery)((Object)this.addFlag(QueryFlag.Position.BEFORE_ORDER, CONNECT_BY_PRIOR, (Expr<?>)cond));
    }

    public OracleQuery connectBy(EBoolean cond) {
        return (OracleQuery)((Object)this.addFlag(QueryFlag.Position.BEFORE_ORDER, CONNECT_BY, (Expr<?>)cond));
    }

    public OracleQuery connectByNocyclePrior(EBoolean cond) {
        return (OracleQuery)((Object)this.addFlag(QueryFlag.Position.BEFORE_ORDER, CONNECT_BY_NOCYCLE_PRIOR, (Expr<?>)cond));
    }

    public <A> OracleQuery startWith(EBoolean cond) {
        return (OracleQuery)((Object)this.addFlag(QueryFlag.Position.BEFORE_ORDER, START_WITH, (Expr<?>)cond));
    }

    public OracleQuery orderSiblingsBy(Expr<?> path) {
        return (OracleQuery)((Object)this.addFlag(QueryFlag.Position.BEFORE_ORDER, ORDER_SIBLINGS_BY, path));
    }
}

