/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.mysql;

import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.sql.AbstractSQLQuery;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.MySQLTemplates;
import com.mysema.query.sql.SQLTemplates;
import java.io.File;
import java.sql.Connection;
import org.apache.commons.lang.StringUtils;

public class MySQLQuery
extends AbstractSQLQuery<MySQLQuery> {
    public MySQLQuery(Connection conn) {
        this(conn, new MySQLTemplates(), (QueryMetadata)new DefaultQueryMetadata());
    }

    public MySQLQuery(Connection conn, SQLTemplates templates) {
        this(conn, templates, (QueryMetadata)new DefaultQueryMetadata());
    }

    protected MySQLQuery(Connection conn, SQLTemplates templates, QueryMetadata metadata) {
        super(conn, new Configuration(templates), metadata);
    }

    public MySQLQuery bigResult() {
        return (MySQLQuery)((Object)this.addFlag(QueryFlag.Position.AFTER_SELECT, "SQL_BIG_RESULT "));
    }

    public MySQLQuery bufferResult() {
        return (MySQLQuery)((Object)this.addFlag(QueryFlag.Position.AFTER_SELECT, "SQL_BUFFER_RESULT "));
    }

    public MySQLQuery cache() {
        return (MySQLQuery)((Object)this.addFlag(QueryFlag.Position.AFTER_SELECT, "SQL_CACHE "));
    }

    public MySQLQuery calcFoundRows() {
        return (MySQLQuery)((Object)this.addFlag(QueryFlag.Position.AFTER_SELECT, "SQL_CALC_FOUND_ROWS "));
    }

    public MySQLQuery forUpdate() {
        return (MySQLQuery)((Object)this.addFlag(QueryFlag.Position.END, "\nFOR UPDATE "));
    }

    public MySQLQuery highPriority() {
        return (MySQLQuery)((Object)this.addFlag(QueryFlag.Position.AFTER_SELECT, "HIGH_PRIORITY "));
    }

    public MySQLQuery into(String var) {
        return (MySQLQuery)((Object)this.addFlag(QueryFlag.Position.END, "\nINTO " + var));
    }

    public MySQLQuery intoDumpfile(File file) {
        return (MySQLQuery)((Object)this.addFlag(QueryFlag.Position.END, "\nINTO DUMPFILE '" + file.getPath() + "'"));
    }

    public MySQLQuery intoOutfile(File file) {
        return (MySQLQuery)((Object)this.addFlag(QueryFlag.Position.END, "\nINTO OUTFILE '" + file.getPath() + "'"));
    }

    public MySQLQuery lockInShareMode() {
        return (MySQLQuery)((Object)this.addFlag(QueryFlag.Position.END, "\nLOCK IN SHARE MODE "));
    }

    public MySQLQuery noCache() {
        return (MySQLQuery)((Object)this.addFlag(QueryFlag.Position.AFTER_SELECT, "SQL_NO_CACHE "));
    }

    public MySQLQuery smallResult() {
        return (MySQLQuery)((Object)this.addFlag(QueryFlag.Position.AFTER_SELECT, "SQL_SMALL_RESULT "));
    }

    public MySQLQuery straightJoin() {
        return (MySQLQuery)((Object)this.addFlag(QueryFlag.Position.AFTER_SELECT, "STRAIGHT_JOIN "));
    }

    public MySQLQuery useIndex(String ... indexes) {
        return (MySQLQuery)((Object)this.addJoinFlag(" USE_INDEX (" + StringUtils.join((Object[])indexes, (String)", ") + ")"));
    }

    public MySQLQuery withRollup() {
        return (MySQLQuery)((Object)this.addFlag(QueryFlag.Position.AFTER_GROUP_BY, "\nWITH ROLLUP "));
    }
}

