/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.mssql;

import com.mysema.query.types.Expr;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.custom.CNumber;
import com.mysema.query.types.expr.EComparable;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.ESimple;
import com.mysema.query.types.path.PNumber;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class RowNumber
extends ESimple<Long> {
    private static final long serialVersionUID = 3499501725767772281L;
    private final List<Expr<?>> partitionBy = new ArrayList();
    private final List<OrderSpecifier<?>> orderBy = new ArrayList();
    @Nullable
    private PNumber<Long> target;

    public RowNumber() {
        super(Long.class);
    }

    public void accept(Visitor v) {
        ArrayList args = new ArrayList(this.partitionBy.size() + this.orderBy.size());
        StringBuilder builder = new StringBuilder("row_number() over (");
        if (!this.partitionBy.isEmpty()) {
            builder.append("partition by ");
            this.appendPartition(args, builder);
        }
        if (!this.orderBy.isEmpty()) {
            if (!this.partitionBy.isEmpty()) {
                builder.append(" ");
            }
            builder.append("order by ");
            this.appendOrder(args, builder);
        }
        builder.append(")");
        if (this.target != null) {
            builder.append(" as {" + args.size() + "}");
            args.add((Expr<?>)this.target);
        }
        ENumber expr = CNumber.create(Long.class, (String)builder.toString(), (Expr[])args.toArray(new Expr[args.size()]));
        expr.accept(v);
    }

    private void appendPartition(List<Expr<?>> args, StringBuilder builder) {
        boolean first = true;
        for (Expr<?> expr : this.partitionBy) {
            if (!first) {
                builder.append(", ");
            }
            builder.append("{" + args.size() + "}");
            args.add(expr);
            first = false;
        }
    }

    private void appendOrder(List<Expr<?>> args, StringBuilder builder) {
        boolean first = true;
        for (OrderSpecifier<?> expr : this.orderBy) {
            if (!first) {
                builder.append(", ");
            }
            builder.append("{" + args.size() + "}");
            if (!expr.isAscending()) {
                builder.append(" desc");
            }
            args.add(expr.getTarget());
            first = false;
        }
    }

    public RowNumber orderBy(OrderSpecifier<?> ... order) {
        for (OrderSpecifier<?> o : order) {
            this.orderBy.add(o);
        }
        return this;
    }

    public RowNumber orderBy(EComparable<?> ... order) {
        for (EComparable<?> o : order) {
            this.orderBy.add(o.asc());
        }
        return this;
    }

    public RowNumber partitionBy(Expr<?> ... exprs) {
        for (Expr<?> expr : exprs) {
            this.partitionBy.add(expr);
        }
        return this;
    }

    public RowNumber as(PNumber<Long> target) {
        this.target = target;
        return this;
    }

    public int hashCode() {
        return ((Object)this.orderBy).hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RowNumber) {
            RowNumber rn = (RowNumber)((Object)o);
            return ((Object)this.partitionBy).equals(rn.partitionBy) && ((Object)this.orderBy).equals(rn.orderBy);
        }
        return false;
    }
}

