/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.dml;

import com.mysema.query.QueryException;
import com.mysema.query.dml.InsertClause;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.dml.AbstractSQLClause;
import com.mysema.query.sql.dml.SQLInsertBatch;
import com.mysema.query.types.Expr;
import com.mysema.query.types.Path;
import com.mysema.query.types.SubQuery;
import com.mysema.query.types.expr.ExprConst;
import com.mysema.query.types.path.NullExpr;
import com.mysema.query.types.path.PEntity;
import com.mysema.util.ResultSetAdapter;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
public class SQLInsertClause
extends AbstractSQLClause
implements InsertClause<SQLInsertClause> {
    private static final Logger logger = LoggerFactory.getLogger(SQLInsertClause.class);
    private final Connection connection;
    private final PEntity<?> entity;
    @Nullable
    private SubQuery<?> subQuery;
    private final List<SQLInsertBatch> batches = new ArrayList<SQLInsertBatch>();
    private final List<Path<?>> columns = new ArrayList();
    private final List<Expr<?>> values = new ArrayList();
    private transient String queryString;

    public SQLInsertClause(Connection connection, SQLTemplates templates, PEntity<?> entity) {
        this(connection, new Configuration(templates), entity);
    }

    public SQLInsertClause(Connection connection, Configuration configuration, PEntity<?> entity) {
        super(configuration);
        this.connection = connection;
        this.entity = entity;
    }

    public SQLInsertClause addBatch() {
        this.batches.add(new SQLInsertBatch(this.columns, this.values, this.subQuery));
        this.columns.clear();
        this.values.clear();
        this.subQuery = null;
        return this;
    }

    protected void close(PreparedStatement stmt) {
        try {
            stmt.close();
        }
        catch (SQLException e) {
            throw new QueryException((Throwable)e);
        }
    }

    protected void close(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException((Throwable)e);
        }
    }

    public SQLInsertClause columns(Path<?> ... columns) {
        this.columns.addAll(Arrays.asList(columns));
        return this;
    }

    @Nullable
    public <T> T executeWithKey(Path<T> path) {
        ResultSet rs = this.executeWithKeys();
        try {
            if (rs.next()) {
                Object object = rs.getObject(1);
                return (T)object;
            }
            T t = null;
            return t;
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.close(rs);
        }
    }

    public <T> List<T> executeWithKeys(Path<T> path) {
        ResultSet rs = this.executeWithKeys();
        try {
            ArrayList<Object> rv = new ArrayList<Object>();
            while (rs.next()) {
                rv.add(rs.getObject(1));
            }
            ArrayList<Object> arrayList = rv;
            return arrayList;
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.close(rs);
        }
    }

    private PreparedStatement createStatement() throws SQLException {
        SQLSerializer serializer = new SQLSerializer(this.configuration.getTemplates(), true);
        PreparedStatement stmt = null;
        if (this.batches.isEmpty()) {
            serializer.serializeForInsert(this.entity, this.columns, this.values, this.subQuery);
            this.queryString = serializer.toString();
            logger.debug(this.queryString);
            stmt = this.connection.prepareStatement(this.queryString);
            this.setParameters(stmt, serializer.getConstants(), Collections.emptyMap());
        } else {
            serializer.serializeForInsert(this.entity, this.batches.get(0).getColumns(), this.batches.get(0).getValues(), this.batches.get(0).getSubQuery());
            this.queryString = serializer.toString();
            logger.debug(this.queryString);
            stmt = this.connection.prepareStatement(this.queryString);
            this.setParameters(stmt, serializer.getConstants(), Collections.emptyMap());
            stmt.addBatch();
            for (int i = 1; i < this.batches.size(); ++i) {
                SQLInsertBatch batch = this.batches.get(i);
                serializer = new SQLSerializer(this.configuration.getTemplates(), true);
                serializer.serializeForInsert(this.entity, batch.getColumns(), batch.getValues(), batch.getSubQuery());
                this.setParameters(stmt, serializer.getConstants(), Collections.emptyMap());
                stmt.addBatch();
            }
        }
        return stmt;
    }

    public ResultSet executeWithKeys() {
        try {
            final PreparedStatement stmt = this.createStatement();
            if (this.batches.isEmpty()) {
                stmt.executeUpdate();
            } else {
                stmt.executeBatch();
            }
            ResultSet rs = stmt.getGeneratedKeys();
            return new ResultSetAdapter(rs){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws SQLException {
                    try {
                        super.close();
                    }
                    finally {
                        stmt.close();
                    }
                }
            };
        }
        catch (SQLException e) {
            throw new QueryException("Caught " + e.getClass().getSimpleName() + " for " + this.queryString, (Throwable)e);
        }
    }

    public long execute() {
        PreparedStatement stmt = null;
        try {
            stmt = this.createStatement();
            if (this.batches.isEmpty()) {
                long l = stmt.executeUpdate();
                return l;
            }
            long rv = 0L;
            for (int i : stmt.executeBatch()) {
                rv += (long)i;
            }
            long l = rv;
            return l;
        }
        catch (SQLException e) {
            throw new QueryException("Caught " + e.getClass().getSimpleName() + " for " + this.queryString, (Throwable)e);
        }
        finally {
            if (stmt != null) {
                this.close(stmt);
            }
        }
    }

    public SQLInsertClause select(SubQuery<?> sq) {
        this.subQuery = sq;
        return this;
    }

    public <T> SQLInsertClause set(Path<T> path, T value) {
        this.columns.add(path);
        if (value instanceof Expr) {
            this.values.add((Expr)value);
        } else if (value != null) {
            this.values.add(ExprConst.create(value));
        } else {
            this.values.add((Expr<?>)new NullExpr(path.getType()));
        }
        return this;
    }

    public SQLInsertClause values(Object ... v) {
        for (Object value : v) {
            if (value instanceof Expr) {
                this.values.add((Expr)value);
                continue;
            }
            if (value != null) {
                this.values.add(ExprConst.create((Object)value));
                continue;
            }
            this.values.add((Expr<?>)NullExpr.DEFAULT);
        }
        return this;
    }

    public String toString() {
        SQLSerializer serializer = new SQLSerializer(this.configuration.getTemplates(), true);
        serializer.serializeForInsert(this.entity, this.columns, this.values, this.subQuery);
        return serializer.toString();
    }
}

