/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.ddl;

import com.mysema.commons.lang.Assert;
import com.mysema.query.QueryException;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.ddl.ForeignKeyBuilder;
import com.mysema.query.sql.support.ColumnData;
import com.mysema.query.sql.support.ForeignKeyData;
import com.mysema.query.sql.support.PrimaryKeyData;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTableClause {
    private static final Logger logger = LoggerFactory.getLogger(CreateTableClause.class);
    private final Connection connection;
    private final SQLTemplates templates;
    private final String table;
    private final List<ColumnData> columns = new ArrayList<ColumnData>();
    private PrimaryKeyData primaryKey;
    private final List<ForeignKeyData> foreignKeys = new ArrayList<ForeignKeyData>();

    public CreateTableClause(Connection conn, SQLTemplates templates, String table) {
        this.connection = conn;
        this.templates = templates;
        this.table = templates.quoteTableName(table);
    }

    public CreateTableClause column(String name, Class<?> type) {
        Assert.notNull((Object)name, (String)"name");
        Assert.notNull(type, (String)"type");
        this.columns.add(new ColumnData(this.templates.quoteColumnName(name), this.templates.getTypeForClass(type)));
        return this;
    }

    private ColumnData lastColumn() {
        return this.columns.get(this.columns.size() - 1);
    }

    public CreateTableClause notNull() {
        this.lastColumn().setNullAllowed(false);
        return this;
    }

    public CreateTableClause size(int size) {
        this.lastColumn().setSize(size);
        return this;
    }

    public CreateTableClause autoIncrement() {
        this.lastColumn().setAutoIncrement(true);
        return this;
    }

    public CreateTableClause primaryKey(String name, String ... columns) {
        Assert.notNull((Object)name, (String)"name");
        Assert.notEmpty((Object[])columns, (String)"columns");
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = this.templates.quoteColumnName(columns[i]);
        }
        this.primaryKey = new PrimaryKeyData(name, columns);
        return this;
    }

    public ForeignKeyBuilder foreignKey(String name, String ... columns) {
        Assert.notNull((Object)name, (String)"name");
        Assert.notEmpty((Object[])columns, (String)"columns");
        return new ForeignKeyBuilder(this, this.templates, this.foreignKeys, name, columns);
    }

    @SuppressWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"})
    public void execute() {
        StringBuilder line;
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE " + this.table + " (\n");
        ArrayList<String> lines = new ArrayList<String>(this.columns.size() + this.foreignKeys.size() + 1);
        for (ColumnData column : this.columns) {
            line = new StringBuilder();
            line.append(column.getName() + " " + column.getType().toUpperCase());
            if (column.getSize() != null) {
                line.append("(" + column.getSize() + ")");
            }
            if (!column.isNullAllowed()) {
                line.append(this.templates.getNotNull().toUpperCase());
            }
            if (column.isAutoIncrement()) {
                line.append(this.templates.getAutoIncrement().toUpperCase());
            }
            lines.add(line.toString());
        }
        if (this.primaryKey != null) {
            StringBuilder line2 = new StringBuilder();
            line2.append("CONSTRAINT " + this.primaryKey.getName() + " ");
            line2.append("PRIMARY KEY(" + StringUtils.join(this.primaryKey.getColumns(), (String)", ") + ")");
            lines.add(line2.toString());
        }
        for (ForeignKeyData foreignKey : this.foreignKeys) {
            line = new StringBuilder();
            line.append("CONSTRAINT " + foreignKey.getName() + " ");
            line.append("FOREIGN KEY(" + StringUtils.join(foreignKey.getForeignColumns(), (String)", ") + ") ");
            line.append("REFERENCES " + foreignKey.getTable() + "(" + StringUtils.join(foreignKey.getParentColumns(), (String)", ") + ")");
            lines.add(line.toString());
        }
        builder.append("  " + StringUtils.join(lines, (String)",\n  "));
        builder.append("\n)\n");
        logger.info(builder.toString());
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
            stmt.execute(builder.toString());
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    throw new QueryException((Throwable)e);
                }
            }
        }
    }
}

