/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.JoinType;
import com.mysema.query.QueryException;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.sql.SerializationContext;
import com.mysema.query.types.Operator;
import com.mysema.query.types.OperatorImpl;
import com.mysema.query.types.Ops;
import com.mysema.query.types.PathType;
import com.mysema.query.types.Templates;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

public class SQLTemplates
extends Templates {
    public static final Operator<Object> CAST = new OperatorImpl("CAST", new Class[]{Object.class, Object.class});
    public static final Operator<Object> UNION = new OperatorImpl("UNION", new Class[0]);
    public static final SQLTemplates DEFAULT = new SQLTemplates();
    private final Map<Class<?>, String> class2type = new HashMap();
    @Nullable
    private String quoteStr;
    private String asc = " asc";
    private String autoIncrement = " auto_increment";
    private String columnAlias = " ";
    private String count = "count ";
    private String countStar = "count(*)";
    private String deleteFrom = "delete from ";
    private String desc = " desc";
    private String distinctCountEnd = ")";
    private String distinctCountStart = "count(distinct ";
    private String dummyTable = "dual";
    private String from = "\nfrom ";
    private String fullJoin = "\nfull join ";
    private String groupBy = "\ngroup by ";
    private String having = "\nhaving ";
    private String innerJoin = "\ninner join ";
    private String insertInto = "insert into ";
    private String join = "\njoin ";
    private String key = "key";
    private String leftJoin = "\nleft join ";
    private String limitTemplate = "\nlimit {0}";
    private String mergeInto = "merge into ";
    private boolean nativeMerge;
    private String notNull = " not null";
    private String offsetTemplate = "\noffset {0}";
    private String on = "\non ";
    private String orderBy = "\norder by ";
    private String select = "select ";
    private String selectDistinct = "select distinct ";
    private String set = "set ";
    private String tableAlias = " ";
    private String union = "\nunion\n";
    private String update = "update ";
    private String values = "\nvalues ";
    private String where = "\nwhere ";

    protected SQLTemplates() {
        this(null);
    }

    protected SQLTemplates(@Nullable String quoteStr) {
        this.quoteStr = quoteStr;
        this.add(Ops.AND, "{0} and {1}", 36);
        this.add(Ops.NOT, "not {0}", 3);
        this.add(Ops.OR, "{0} or {1}", 38);
        this.add(Ops.XNOR, "{0} xnor {1}", 39);
        this.add(Ops.XOR, "{0} xor {1}", 39);
        this.add(Ops.MathOps.RANDOM, "rand()");
        this.add(Ops.MathOps.CEIL, "ceiling({0})");
        this.add(Ops.MathOps.POWER, "power({0},{1})");
        this.add(Ops.MOD, "mod({0},{1})", 0);
        this.add(Ops.DateTimeOps.CURRENT_DATE, "current_date");
        this.add(Ops.DateTimeOps.CURRENT_TIME, "current_timestamp");
        this.add(Ops.DateTimeOps.MILLISECOND, "0");
        this.add(Ops.DateTimeOps.YEAR_MONTH, "year({0}) * 100 + month({0})");
        this.add(Ops.CHAR_AT, "cast(substr({0},{1}+1,1) as char)");
        this.add(Ops.ENDS_WITH, "{0} like {%1}");
        this.add(Ops.ENDS_WITH_IC, "{0l} like {%%1}");
        this.add(Ops.EQ_IGNORE_CASE, "{0l} = {1l}");
        this.add(Ops.INDEX_OF, "locate({1},{0})-1");
        this.add(Ops.INDEX_OF_2ARGS, "locate({1},{0},{2}+1)-1");
        this.add(Ops.STARTS_WITH, "{0} like {1%}");
        this.add(Ops.STARTS_WITH_IC, "{0l} like {1%%}");
        this.add(Ops.STRING_CONTAINS, "{0} like {%1%}");
        this.add(Ops.STRING_CONTAINS_IC, "{0l} like {%%1%%}");
        this.add(Ops.STRING_IS_EMPTY, "length({0}) = 0");
        this.add(Ops.SUBSTR_1ARG, "substr({0},{1}+1)");
        this.add(Ops.SUBSTR_2ARGS, "substr({0},{1}+1,{2})");
        if (quoteStr != null) {
            this.add((Operator)PathType.PROPERTY, "{0}." + quoteStr + "{1s}" + quoteStr);
            this.add((Operator)PathType.VARIABLE, quoteStr + "{0s}" + quoteStr);
        }
        this.add(CAST, "cast({0} as {1s})");
        this.add(UNION, "{0}\nunion\n{1}");
        for (Class cl : new Class[]{Boolean.class, Byte.class, Double.class, Float.class, Integer.class, Long.class, Short.class, String.class}) {
            this.class2type.put(cl, cl.getSimpleName().toLowerCase(Locale.ENGLISH));
        }
        this.class2type.put(Boolean.class, "bit");
        this.class2type.put(Byte.class, "tinyint");
        this.class2type.put(Long.class, "bigint");
        this.class2type.put(Short.class, "smallint");
        this.class2type.put(String.class, "varchar");
        this.class2type.put(Date.class, "date");
        this.class2type.put(Time.class, "time");
        this.class2type.put(Timestamp.class, "timestamp");
    }

    public void addClass2TypeMappings(String type, Class<?> ... classes) {
        for (Class<?> cl : classes) {
            this.class2type.put(cl, type);
        }
    }

    public String getAsc() {
        return this.asc;
    }

    public String getAutoIncrement() {
        return this.autoIncrement;
    }

    public String getColumnAlias() {
        return this.columnAlias;
    }

    public String getCount() {
        return this.count;
    }

    public String getCountStar() {
        return this.countStar;
    }

    public String getDeleteFrom() {
        return this.deleteFrom;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getDistinctCountEnd() {
        return this.distinctCountEnd;
    }

    public String getDistinctCountStart() {
        return this.distinctCountStart;
    }

    public String getDummyTable() {
        return this.dummyTable;
    }

    public String getFrom() {
        return this.from;
    }

    public String getFullJoin() {
        return this.fullJoin;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public String getHaving() {
        return this.having;
    }

    public String getInnerJoin() {
        return this.innerJoin;
    }

    public String getInsertInto() {
        return this.insertInto;
    }

    public String getJoin() {
        return this.join;
    }

    public String getJoinSymbol(JoinType joinType) {
        switch (joinType) {
            case FULLJOIN: {
                return this.fullJoin;
            }
            case INNERJOIN: {
                return this.innerJoin;
            }
            case JOIN: {
                return this.join;
            }
            case LEFTJOIN: {
                return this.leftJoin;
            }
        }
        return ", ";
    }

    public String getKey() {
        return this.key;
    }

    public String getLeftJoin() {
        return this.leftJoin;
    }

    public String getLimitTemplate() {
        return this.limitTemplate;
    }

    public String getMergeInto() {
        return this.mergeInto;
    }

    public String getNotNull() {
        return this.notNull;
    }

    public String getOffsetTemplate() {
        return this.offsetTemplate;
    }

    public String getOn() {
        return this.on;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public String getSelect() {
        return this.select;
    }

    public String getSelectDistinct() {
        return this.selectDistinct;
    }

    public String getSet() {
        return this.set;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public String getTypeForClass(Class<?> cl) {
        return this.class2type.get(cl);
    }

    public String getUnion() {
        return this.union;
    }

    public String getUpdate() {
        return this.update;
    }

    public String getValues() {
        return this.values;
    }

    public String getWhere() {
        return this.where;
    }

    public boolean isNativeMerge() {
        return this.nativeMerge;
    }

    public boolean isSupportsAlias() {
        return true;
    }

    public SQLTemplates newLineToSingleSpace() {
        for (Field field : SQLTemplates.class.getDeclaredFields()) {
            try {
                Object val;
                if (!field.getType().equals(String.class) || (val = field.get((Object)this)) == null) continue;
                field.set((Object)this, val.toString().replace('\n', ' '));
            }
            catch (IllegalAccessException e) {
                throw new QueryException(e.getMessage(), (Throwable)e);
            }
        }
        return this;
    }

    public final String quoteColumnName(String column) {
        if (this.quoteStr != null) {
            return this.quoteStr + column + this.quoteStr;
        }
        return column;
    }

    public final String quoteTableName(String table) {
        if (this.quoteStr != null) {
            return this.quoteStr + table + this.quoteStr;
        }
        return table;
    }

    public void serialize(QueryMetadata metadata, boolean forCountRow, SerializationContext context) {
        context.serialize(metadata, forCountRow);
        if (!forCountRow && metadata.getModifiers().isRestricting()) {
            this.serializeModifiers(metadata, context);
        }
    }

    protected void serializeModifiers(QueryMetadata metadata, SerializationContext context) {
        QueryModifiers mod = metadata.getModifiers();
        if (mod.getLimit() != null) {
            context.handle(this.limitTemplate, mod.getLimit());
        }
        if (mod.getOffset() != null) {
            context.handle(this.offsetTemplate, mod.getOffset());
        }
    }

    protected void setAsc(String asc) {
        this.asc = asc;
    }

    protected void setAutoIncrement(String autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    protected void setColumnAlias(String columnAlias) {
        this.columnAlias = columnAlias;
    }

    protected void setCount(String count) {
        this.count = count;
    }

    protected void setCountStar(String countStar) {
        this.countStar = countStar;
    }

    protected void setDeleteFrom(String deleteFrom) {
        this.deleteFrom = deleteFrom;
    }

    protected void setDesc(String desc) {
        this.desc = desc;
    }

    protected void setDistinctCountEnd(String distinctCountEnd) {
        this.distinctCountEnd = distinctCountEnd;
    }

    protected void setDistinctCountStart(String distinctCountStart) {
        this.distinctCountStart = distinctCountStart;
    }

    protected void setDummyTable(String dummyTable) {
        this.dummyTable = dummyTable;
    }

    protected void setFrom(String from) {
        this.from = from;
    }

    protected void setFullJoin(String fullJoin) {
        this.fullJoin = fullJoin;
    }

    protected void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    protected void setHaving(String having) {
        this.having = having;
    }

    protected void setInnerJoin(String innerJoin) {
        this.innerJoin = innerJoin;
    }

    protected void setInsertInto(String insertInto) {
        this.insertInto = insertInto;
    }

    protected void setJoin(String join) {
        this.join = join;
    }

    public void setKey(String key) {
        this.key = key;
    }

    protected void setLeftJoin(String leftJoin) {
        this.leftJoin = leftJoin;
    }

    protected void setMergeInto(String mergeInto) {
        this.mergeInto = mergeInto;
    }

    protected void setNativeMerge(boolean nativeMerge) {
        this.nativeMerge = nativeMerge;
    }

    protected void setNotNull(String notNull) {
        this.notNull = notNull;
    }

    protected void setOffsetTemplate(String offsetTemplate) {
        this.offsetTemplate = offsetTemplate;
    }

    protected void setOn(String on) {
        this.on = on;
    }

    protected void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    protected void setSelect(String select) {
        this.select = select;
    }

    protected void setSelectDistinct(String selectDistinct) {
        this.selectDistinct = selectDistinct;
    }

    protected void setSet(String set) {
        this.set = set;
    }

    protected void setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias;
    }

    protected void setUnion(String union) {
        this.union = union;
    }

    protected void setUpdate(String update) {
        this.update = update;
    }

    protected void setValues(String values) {
        this.values = values;
    }

    protected void setWhere(String where) {
        this.where = where;
    }
}

