/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.types.BigDecimalType;
import com.mysema.query.sql.types.BlobType;
import com.mysema.query.sql.types.BooleanType;
import com.mysema.query.sql.types.ByteType;
import com.mysema.query.sql.types.BytesType;
import com.mysema.query.sql.types.CharacterType;
import com.mysema.query.sql.types.ClobType;
import com.mysema.query.sql.types.DateType;
import com.mysema.query.sql.types.DoubleType;
import com.mysema.query.sql.types.FloatType;
import com.mysema.query.sql.types.IntegerType;
import com.mysema.query.sql.types.LongType;
import com.mysema.query.sql.types.ObjectType;
import com.mysema.query.sql.types.ShortType;
import com.mysema.query.sql.types.StringType;
import com.mysema.query.sql.types.TimeType;
import com.mysema.query.sql.types.TimestampType;
import com.mysema.query.sql.types.Type;
import com.mysema.query.sql.types.URLType;
import com.mysema.query.sql.types.UtilDateType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class Configuration {
    private static final Map<Class<?>, Type<?>> defaultTypes = new HashMap();
    private final Map<Class<?>, Type<?>> types = new HashMap();
    private final SQLTemplates templates;

    private static void registerDefault(Type<?> type) {
        defaultTypes.put(type.getReturnedClass(), type);
    }

    public Configuration(SQLTemplates templates) {
        this.templates = templates;
    }

    public SQLTemplates getTemplates() {
        return this.templates;
    }

    public void register(Type<?> type) {
        this.types.put(type.getReturnedClass(), type);
    }

    @Nullable
    public <T> T get(ResultSet rs, int i, Class<T> clazz) throws SQLException {
        Type<T> type = this.getType(clazz);
        return type.getValue(rs, i);
    }

    public <T> int set(PreparedStatement stmt, int i, T value) throws SQLException {
        Type<?> type = this.getType(value.getClass());
        type.setValue(stmt, i, value);
        return type.getSQLTypes().length;
    }

    private <T> Type<T> getType(Class<T> clazz) {
        if (this.types.containsKey(clazz)) {
            return this.types.get(clazz);
        }
        if (defaultTypes.containsKey(clazz)) {
            return defaultTypes.get(clazz);
        }
        throw new IllegalArgumentException("Got not type for " + clazz.getName());
    }

    static {
        Configuration.registerDefault(new BigDecimalType());
        Configuration.registerDefault(new BlobType());
        Configuration.registerDefault(new BooleanType());
        Configuration.registerDefault(new BytesType());
        Configuration.registerDefault(new ByteType());
        Configuration.registerDefault(new CharacterType());
        Configuration.registerDefault(new ClobType());
        Configuration.registerDefault(new DateType());
        Configuration.registerDefault(new DoubleType());
        Configuration.registerDefault(new FloatType());
        Configuration.registerDefault(new IntegerType());
        Configuration.registerDefault(new LongType());
        Configuration.registerDefault(new ObjectType());
        Configuration.registerDefault(new ShortType());
        Configuration.registerDefault(new StringType());
        Configuration.registerDefault(new TimestampType());
        Configuration.registerDefault(new TimeType());
        Configuration.registerDefault(new URLType());
        Configuration.registerDefault(new UtilDateType());
    }
}

