/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.codegen;

import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.model.Types;
import com.mysema.query.codegen.EntitySerializer;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.SerializerConfig;
import com.mysema.query.codegen.TypeMappings;
import com.mysema.query.sql.ForeignKey;
import com.mysema.query.sql.PrimaryKey;
import com.mysema.query.sql.RelationalPathBase;
import com.mysema.query.sql.codegen.NamingStrategy;
import com.mysema.query.sql.support.ForeignKeyData;
import com.mysema.query.sql.support.InverseForeignKeyData;
import com.mysema.query.sql.support.KeyData;
import com.mysema.query.sql.support.PrimaryKeyData;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;

public class MetaDataSerializer
extends EntitySerializer {
    private final NamingStrategy namingStrategy;
    private final boolean innerClassesForKeys;

    @Inject
    public MetaDataSerializer(TypeMappings typeMappings, NamingStrategy namingStrategy, @Named(value="innerClassesForKeys") boolean innerClassesForKeys) {
        super(typeMappings, Collections.emptyList());
        this.namingStrategy = namingStrategy;
        this.innerClassesForKeys = innerClassesForKeys;
    }

    protected void introClassHeader(CodeWriter writer, EntityType model) throws IOException {
        Type queryType = this.typeMappings.getPathType((Type)model, model, true);
        writer.line(new String[]{"@Generated(\"", ((Object)((Object)this)).getClass().getName(), "\")"});
        TypeCategory category = model.getOriginalCategory();
        if (model.equals((Object)queryType)) {
            for (Annotation annotation : model.getAnnotations()) {
                writer.annotation(annotation);
            }
        }
        writer.beginClass(queryType, (Type)new ClassType(category, RelationalPathBase.class, new Type[]{model}), new Type[0]);
        writer.privateStaticFinal((Type)Types.LONG_P, "serialVersionUID", String.valueOf(model.hashCode()));
    }

    protected String getAdditionalConstructorParameter(EntityType model) {
        StringBuilder builder = new StringBuilder();
        if (model.getData().containsKey("schema")) {
            builder.append(", \"").append(model.getData().get("schema")).append("\"");
        } else {
            builder.append(", null");
        }
        builder.append(", \"").append(model.getData().get("table")).append("\"");
        return builder.toString();
    }

    protected void introDefaultInstance(CodeWriter writer, EntityType entityType) throws IOException {
        String variableName = this.namingStrategy.getDefaultVariableName(entityType);
        String alias = this.namingStrategy.getDefaultAlias(entityType);
        Type queryType = this.typeMappings.getPathType((Type)entityType, entityType, true);
        writer.publicStaticFinal(queryType, variableName, "new " + queryType.getSimpleName() + "(\"" + alias + "\")");
    }

    protected void introImports(CodeWriter writer, SerializerConfig config, EntityType model) throws IOException {
        super.introImports(writer, config, model);
        Collection foreignKeys = (Collection)model.getData().get(ForeignKeyData.class);
        Collection inverseForeignKeys = (Collection)model.getData().get(InverseForeignKeyData.class);
        boolean addJavaUtilImport = false;
        if (foreignKeys != null) {
            for (KeyData keyData : foreignKeys) {
                if (((ForeignKeyData)keyData).getForeignColumns().size() <= 1) continue;
                addJavaUtilImport = true;
            }
        }
        if (inverseForeignKeys != null) {
            for (KeyData keyData : inverseForeignKeys) {
                if (((InverseForeignKeyData)keyData).getForeignColumns().size() <= 1) continue;
                addJavaUtilImport = true;
            }
        }
        if (addJavaUtilImport) {
            writer.imports(new Package[]{List.class.getPackage()});
        }
    }

    protected void serializeProperties(EntityType model, SerializerConfig config, CodeWriter writer) throws IOException {
        Collection primaryKeys = (Collection)model.getData().get(PrimaryKeyData.class);
        Collection foreignKeys = (Collection)model.getData().get(ForeignKeyData.class);
        Collection inverseForeignKeys = (Collection)model.getData().get(InverseForeignKeyData.class);
        if (this.innerClassesForKeys) {
            SimpleType primaryKeyType = new SimpleType(this.namingStrategy.getPrimaryKeysClassName());
            SimpleType foreignKeysType = new SimpleType(this.namingStrategy.getForeignKeysClassName());
            if (primaryKeys != null) {
                writer.beginClass((Type)primaryKeyType);
                this.serializePrimaryKeys(model, writer, primaryKeys);
                writer.end();
            }
            if (foreignKeys != null || inverseForeignKeys != null) {
                writer.beginClass((Type)foreignKeysType);
                if (foreignKeys != null) {
                    this.serializeForeignKeys(model, writer, foreignKeys, false);
                }
                if (inverseForeignKeys != null) {
                    this.serializeForeignKeys(model, writer, inverseForeignKeys, true);
                }
                writer.end();
            }
            super.serializeProperties(model, config, writer);
            if (primaryKeys != null) {
                writer.publicFinal((Type)primaryKeyType, this.namingStrategy.getPrimaryKeysVariable(model), "new " + primaryKeyType.getSimpleName() + "()");
            }
            if (foreignKeys != null || inverseForeignKeys != null) {
                writer.publicFinal((Type)foreignKeysType, this.namingStrategy.getForeignKeysVariable(model), "new " + foreignKeysType.getSimpleName() + "()");
            }
        } else {
            super.serializeProperties(model, config, writer);
            if (primaryKeys != null) {
                this.serializePrimaryKeys(model, writer, primaryKeys);
            }
            if (foreignKeys != null) {
                this.serializeForeignKeys(model, writer, foreignKeys, false);
            }
            if (inverseForeignKeys != null) {
                this.serializeForeignKeys(model, writer, inverseForeignKeys, true);
            }
        }
    }

    protected void serializePrimaryKeys(EntityType model, CodeWriter writer, Collection<PrimaryKeyData> primaryKeys) throws IOException {
        for (PrimaryKeyData primaryKey : primaryKeys) {
            String fieldName = this.namingStrategy.getPropertyNameForPrimaryKey(primaryKey.getName(), model);
            StringBuilder value = new StringBuilder("createPrimaryKey(");
            boolean first = true;
            for (String column : primaryKey.getColumns()) {
                if (!first) {
                    value.append(", ");
                }
                value.append(this.namingStrategy.getPropertyName(column, model));
                first = false;
            }
            value.append(")");
            ClassType type = new ClassType(PrimaryKey.class, new Type[]{model});
            writer.publicFinal((Type)type, fieldName, value.toString());
        }
    }

    protected void serializeForeignKeys(EntityType model, CodeWriter writer, Collection<? extends KeyData> foreignKeys, boolean inverse) throws IOException {
        for (KeyData keyData : foreignKeys) {
            String fieldName = inverse ? this.namingStrategy.getPropertyNameForInverseForeignKey(keyData.getName(), model) : this.namingStrategy.getPropertyNameForForeignKey(keyData.getName(), model);
            StringBuilder value = new StringBuilder();
            if (inverse) {
                value.append("createInvForeignKey(");
            } else {
                value.append("createForeignKey(");
            }
            if (keyData.getForeignColumns().size() == 1) {
                value.append(this.namingStrategy.getPropertyName(keyData.getForeignColumns().get(0), model));
                value.append(", \"" + keyData.getParentColumns().get(0) + "\"");
            } else {
                StringBuilder local = new StringBuilder();
                StringBuilder foreign = new StringBuilder();
                for (int i = 0; i < keyData.getForeignColumns().size(); ++i) {
                    if (i > 0) {
                        local.append(", ");
                        foreign.append(", ");
                    }
                    local.append(this.namingStrategy.getPropertyName(keyData.getForeignColumns().get(0), model));
                    foreign.append("\"" + keyData.getParentColumns().get(0) + "\"");
                }
                value.append("Arrays.asList(" + local + "), Arrays.asList(" + foreign + ")");
            }
            value.append(")");
            ClassType type = new ClassType(ForeignKey.class, new Type[]{keyData.getType()});
            writer.publicFinal((Type)type, fieldName, value.toString());
        }
    }
}

