/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mysema.commons.lang.CloseableIterator;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.NonUniqueResultException;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.SimpleProjectable;
import com.mysema.query.SimpleQuery;
import com.mysema.query.mongodb.MongodbSerializer;
import com.mysema.query.support.QueryMixin;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections15.Transformer;

public class MongodbQuery<K>
implements SimpleQuery<MongodbQuery<K>>,
SimpleProjectable<K> {
    private final MongodbSerializer serializer;
    private final QueryMixin<MongodbQuery<K>> queryMixin = new QueryMixin((Object)this, (QueryMetadata)new DefaultQueryMetadata(false));
    private final DBCollection collection;
    private final Transformer<DBObject, K> transformer;

    public MongodbQuery(DBCollection collection, Transformer<DBObject, K> transformer, MongodbSerializer serializer) {
        this.transformer = transformer;
        this.collection = collection;
        this.serializer = serializer;
    }

    public boolean exists() {
        return this.collection.findOne(this.createQuery()) != null;
    }

    public boolean notExists() {
        return this.collection.findOne(this.createQuery()) == null;
    }

    public MongodbQuery<K> distinct() {
        return (MongodbQuery)this.queryMixin.distinct();
    }

    public MongodbQuery<K> where(Predicate ... e) {
        return (MongodbQuery)this.queryMixin.where(e);
    }

    public MongodbQuery<K> limit(long limit) {
        return (MongodbQuery)this.queryMixin.limit(limit);
    }

    public MongodbQuery<K> offset(long offset) {
        return (MongodbQuery)this.queryMixin.offset(offset);
    }

    public MongodbQuery<K> restrict(QueryModifiers modifiers) {
        return (MongodbQuery)this.queryMixin.restrict(modifiers);
    }

    public MongodbQuery<K> orderBy(OrderSpecifier<?> ... o) {
        return (MongodbQuery)this.queryMixin.orderBy(o);
    }

    public <T> MongodbQuery<K> set(ParamExpression<T> param, T value) {
        return (MongodbQuery)this.queryMixin.set(param, value);
    }

    public CloseableIterator<K> iterate() {
        final DBCursor cursor = this.createCursor();
        return new CloseableIterator<K>(){

            public boolean hasNext() {
                return cursor.hasNext();
            }

            public K next() {
                return MongodbQuery.this.transformer.transform((Object)cursor.next());
            }

            public void remove() {
            }

            public void close() {
            }
        };
    }

    public CloseableIterator<K> iterateDistinct() {
        return this.iterate();
    }

    public List<K> list() {
        DBCursor cursor = this.createCursor();
        ArrayList<Object> results = new ArrayList<Object>(cursor.size());
        for (DBObject dbObject : cursor) {
            results.add(this.transformer.transform((Object)dbObject));
        }
        return results;
    }

    protected DBCursor createCursor() {
        QueryMetadata metadata = this.queryMixin.getMetadata();
        QueryModifiers modifiers = metadata.getModifiers();
        DBCursor cursor = this.collection.find(this.createQuery());
        if (modifiers.getLimit() != null) {
            cursor.limit(modifiers.getLimit().intValue());
        }
        if (modifiers.getOffset() != null) {
            cursor.skip(modifiers.getOffset().intValue());
        }
        if (metadata.getOrderBy().size() > 0) {
            cursor.sort(this.serializer.toSort(metadata.getOrderBy()));
        }
        return cursor;
    }

    public List<K> listDistinct() {
        return this.list();
    }

    public K singleResult() {
        DBCursor c = this.createCursor().limit(1);
        if (c.hasNext()) {
            return (K)this.transformer.transform((Object)c.next());
        }
        return null;
    }

    public K uniqueResult() {
        DBCursor c;
        Long limit = this.queryMixin.getMetadata().getModifiers().getLimit();
        if (limit == null) {
            limit = 2L;
        }
        if ((c = this.createCursor().limit(limit.intValue())).hasNext()) {
            Object rv = this.transformer.transform((Object)c.next());
            if (c.hasNext()) {
                throw new NonUniqueResultException();
            }
            return (K)rv;
        }
        return null;
    }

    public SearchResults<K> listResults() {
        long total = this.count();
        if (total > 0L) {
            return new SearchResults(this.list(), this.queryMixin.getMetadata().getModifiers(), total);
        }
        return SearchResults.emptyResults();
    }

    public SearchResults<K> listDistinctResults() {
        return this.listResults();
    }

    public long count() {
        return this.collection.count(this.createQuery());
    }

    public long countDistinct() {
        return this.count();
    }

    private DBObject createQuery() {
        QueryMetadata metadata = this.queryMixin.getMetadata();
        if (metadata.getWhere() != null) {
            return (DBObject)this.serializer.handle((Expression<?>)metadata.getWhere());
        }
        return new BasicDBObject();
    }

    public String toString() {
        return this.createQuery().toString();
    }
}

