/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.maven;

import com.mysema.query.codegen.GenericExporter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public abstract class AbstractExporterMojo
extends AbstractMojo {
    private File targetFolder;
    private boolean scala;
    private String[] packages;
    private MavenProject project;
    private String sourceEncoding;
    private boolean testClasspath;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ClassLoader classLoader = null;
        try {
            classLoader = this.getProjectClassLoader();
        }
        catch (MalformedURLException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        Charset charset = this.sourceEncoding != null ? Charset.forName(this.sourceEncoding) : Charset.defaultCharset();
        GenericExporter exporter = new GenericExporter(classLoader, charset);
        exporter.setTargetFolder(this.targetFolder);
        if (this.scala) {
            try {
                exporter.setSerializerClass(Class.forName("com.mysema.query.scala.ScalaEntitySerializer"));
                exporter.setTypeMappingsClass(Class.forName("com.mysema.query.scala.ScalaTypeMappings"));
                exporter.setCreateScalaSources(true);
            }
            catch (ClassNotFoundException e) {
                throw new MojoFailureException(e.getMessage(), (Throwable)e);
            }
        }
        this.configure(exporter);
        exporter.export(this.packages);
    }

    protected abstract void configure(GenericExporter var1);

    protected ClassLoader getProjectClassLoader() throws DependencyResolutionRequiredException, MalformedURLException {
        List classpathElements = this.testClasspath ? this.project.getTestClasspathElements() : this.project.getCompileClasspathElements();
        ArrayList<URL> urls = new ArrayList<URL>(classpathElements.size());
        for (String element : classpathElements) {
            File file = new File(element);
            if (!file.exists()) continue;
            urls.add(file.toURI().toURL());
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
    }
}

