/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.google.common.collect.Lists;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLOps;
import com.mysema.query.support.EnumConversion;
import com.mysema.query.support.NumberConversion;
import com.mysema.query.support.NumberConversions;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.FactoryExpressionUtils;
import com.mysema.query.types.Operation;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;

public final class Conversions {
    public static <RT> Expression<RT> convert(Expression<RT> expr) {
        if (Conversions.isAggSumWithConversion(expr) || Conversions.isCountAggConversion(expr)) {
            return new NumberConversion(expr);
        }
        if (expr instanceof FactoryExpression) {
            FactoryExpression factorye = (FactoryExpression)expr;
            for (Expression e : factorye.getArgs()) {
                if (!Conversions.isAggSumWithConversion(e) && !Conversions.isCountAggConversion(expr)) continue;
                return new NumberConversions(factorye);
            }
        }
        return expr;
    }

    private static boolean isEntityPathAndNeedsWrapping(Expression<?> expr) {
        Path path;
        return (expr instanceof Path && expr.getType().isAnnotationPresent(Entity.class) || expr instanceof EntityPath && !RelationalPath.class.isInstance(expr)) && (path = (Path)expr).getMetadata().getParent() == null;
    }

    private static <RT> FactoryExpression<RT> createEntityPathConversions(FactoryExpression<RT> factorye) {
        ArrayList conversions = Lists.newArrayList();
        for (Expression e : factorye.getArgs()) {
            if (Conversions.isEntityPathAndNeedsWrapping(e)) {
                conversions.add(OperationImpl.create((Class)e.getType(), (Operator)SQLOps.ALL, (Expression)e));
                continue;
            }
            conversions.add(e);
        }
        return FactoryExpressionUtils.wrap(factorye, (List)conversions);
    }

    public static <RT> Expression<RT> convertForNativeQuery(Expression<RT> expr) {
        if (Conversions.isEntityPathAndNeedsWrapping(expr)) {
            return OperationImpl.create((Class)expr.getType(), (Operator)SQLOps.ALL, expr);
        }
        if (Number.class.isAssignableFrom(expr.getType())) {
            return new NumberConversion(expr);
        }
        if (Enum.class.isAssignableFrom(expr.getType())) {
            return new EnumConversion(expr);
        }
        if (expr instanceof FactoryExpression) {
            NumberConversions factorye = (NumberConversions)expr;
            boolean numberConversions = false;
            boolean hasEntityPath = false;
            for (Expression e : factorye.getArgs()) {
                if (Conversions.isEntityPathAndNeedsWrapping(e)) {
                    hasEntityPath = true;
                    continue;
                }
                if (Number.class.isAssignableFrom(e.getType())) {
                    numberConversions = true;
                    continue;
                }
                if (!Enum.class.isAssignableFrom(e.getType())) continue;
                numberConversions = true;
            }
            if (hasEntityPath) {
                factorye = Conversions.createEntityPathConversions(factorye);
            }
            if (numberConversions) {
                factorye = new NumberConversions(factorye);
            }
            return factorye;
        }
        return expr;
    }

    private static boolean isAggSumWithConversion(Expression<?> expr) {
        Operation operation;
        Class type;
        if ((expr = ExpressionUtils.extract(expr)) instanceof Operation && ((type = (operation = (Operation)expr).getType()).equals(Float.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(Short.class) || type.equals(Byte.class))) {
            if (operation.getOperator() == Ops.AggOps.SUM_AGG) {
                return true;
            }
            for (Expression e : operation.getArgs()) {
                if (!Conversions.isAggSumWithConversion(e)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCountAggConversion(Expression<?> expr) {
        if ((expr = ExpressionUtils.extract(expr)) instanceof Operation) {
            Operation operation = (Operation)expr;
            return operation.getOperator() == Ops.AggOps.COUNT_AGG;
        }
        return false;
    }

    private Conversions() {
    }
}

