/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.collections;

import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import com.mysema.query.QueryException;
import com.mysema.query.collections.ColQueryFunctions;
import com.mysema.query.collections.ColQueryTemplates;
import com.mysema.query.support.SerializerBase;
import com.mysema.query.types.Constant;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathType;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.Template;
import com.mysema.query.types.Templates;
import com.mysema.query.types.Visitor;
import com.mysema.util.BeanUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class ColQuerySerializer
extends SerializerBase<ColQuerySerializer> {
    private static final Map<Operator<?>, String> operatorSymbols = Maps.newHashMap();
    private static final Map<Class<?>, String> castSuffixes = Maps.newHashMap();

    public ColQuerySerializer(ColQueryTemplates templates) {
        super((Templates)templates);
    }

    public Void visit(Path<?> path, Void context) {
        PathType pathType = path.getMetadata().getPathType();
        if (pathType == PathType.PROPERTY) {
            String prefix = "get";
            if (path.getType() != null && path.getType().equals(Boolean.class)) {
                prefix = "is";
            }
            String property = path.getMetadata().getExpression().toString();
            String accessor = prefix + BeanUtils.capitalize((String)property);
            Class parentType = path.getMetadata().getParent().getType();
            try {
                Method m = this.getMethod(parentType, accessor);
                if (m != null && Modifier.isPublic(m.getModifiers())) {
                    this.handle((Expression)path.getMetadata().getParent());
                    ((ColQuerySerializer)((ColQuerySerializer)this.append(new String[]{"."})).append(new String[]{accessor})).append(new String[]{"()"});
                }
                Field f = this.getField(parentType, property);
                if (f != null && Modifier.isPublic(f.getModifiers())) {
                    this.handle((Expression)path.getMetadata().getParent());
                    ((ColQuerySerializer)this.append(new String[]{"."})).append(new String[]{property});
                }
                this.append(new String[]{ColQueryFunctions.class.getName() + ".<"});
                ((ColQuerySerializer)this.append(new String[]{path.getType().getName()})).append(new String[]{">get("});
                this.handle((Expression)path.getMetadata().getParent());
                this.append(new String[]{", \"" + property + "\")"});
            }
            catch (Exception e) {
                throw new QueryException((Throwable)e);
            }
        } else if (pathType == PathType.DELEGATE) {
            this.append(new String[]{"("});
            ((ColQuerySerializer)((ColQuerySerializer)this.append(new String[]{"("})).append(new String[]{path.getType().getName()})).append(new String[]{")"});
            path.getMetadata().getParent().accept((Visitor)this, (Object)context);
            this.append(new String[]{")"});
        } else {
            ArrayList<Object> args = new ArrayList<Object>(2);
            if (path.getMetadata().getParent() != null) {
                args.add(path.getMetadata().getParent());
            }
            args.add(path.getMetadata().getExpression());
            Template template = this.getTemplate((Operator)pathType);
            for (Template.Element element : template.getElements()) {
                if (element.getStaticText() != null) {
                    this.append(new String[]{element.getStaticText()});
                    continue;
                }
                if (element.isAsString()) {
                    this.append(new String[]{((Expression)args.get(element.getIndex())).toString()});
                    continue;
                }
                this.handle((Expression)args.get(element.getIndex()));
            }
        }
        return null;
    }

    private Method getMethod(Class<?> owner, String method) {
        try {
            return owner.getMethod(method, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Field getField(Class<?> owner, String field) {
        try {
            return owner.getField(field);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public Void visit(SubQueryExpression<?> expr, Void context) {
        throw new IllegalArgumentException("Not supported");
    }

    private void visitCast(Operator<?> operator, Expression<?> source, Class<?> targetType) {
        if (Number.class.isAssignableFrom(source.getType()) && !Constant.class.isInstance(source)) {
            ((ColQuerySerializer)((ColQuerySerializer)this.append(new String[]{"new "})).append(new String[]{source.getType().getSimpleName()})).append(new String[]{"("});
            this.handle(source);
            this.append(new String[]{")"});
        } else {
            this.handle(source);
        }
        if (!castSuffixes.containsKey(targetType)) {
            throw new IllegalArgumentException("Unsupported cast type " + targetType.getName());
        }
        this.append(new String[]{castSuffixes.get(targetType)});
    }

    protected void visitOperation(Class<?> type, Operator<?> operator, List<? extends Expression<?>> args) {
        if (args.size() == 2 && operatorSymbols.containsKey(operator) && ColQuerySerializer.isPrimitive(args.get(0).getType()) && ColQuerySerializer.isPrimitive(args.get(1).getType())) {
            this.handle(args.get(0));
            this.append(new String[]{operatorSymbols.get(operator)});
            this.handle(args.get(1));
            if (args.get(1) instanceof Constant) {
                this.append(new String[]{castSuffixes.get(args.get(1).getType())});
            }
            return;
        }
        if (operator == Ops.STRING_CAST) {
            this.visitCast(operator, args.get(0), String.class);
        } else if (operator == Ops.NUMCAST) {
            this.visitCast(operator, args.get(0), (Class)((Constant)args.get(1)).getConstant());
        } else {
            super.visitOperation(type, operator, args);
        }
    }

    private static boolean isPrimitive(Class<?> type) {
        return type.isPrimitive() || Primitives.isWrapperType(type);
    }

    public Void visit(FactoryExpression<?> expr, Void context) {
        this.handle((Expression)new ConstantImpl(expr));
        this.append(new String[]{".newInstance("});
        this.handle(", ", expr.getArgs());
        this.append(new String[]{")"});
        return null;
    }

    static {
        operatorSymbols.put(Ops.EQ, " == ");
        operatorSymbols.put(Ops.NE, " != ");
        operatorSymbols.put(Ops.GT, " > ");
        operatorSymbols.put(Ops.LT, " < ");
        operatorSymbols.put(Ops.GOE, " >= ");
        operatorSymbols.put(Ops.LOE, " <= ");
        castSuffixes.put(Byte.class, ".byteValue()");
        castSuffixes.put(Character.class, ".charValue()");
        castSuffixes.put(Double.class, ".doubleValue()");
        castSuffixes.put(Float.class, ".floatValue()");
        castSuffixes.put(Integer.class, ".intValue()");
        castSuffixes.put(Long.class, ".longValue()");
        castSuffixes.put(Short.class, ".shortValue()");
        castSuffixes.put(String.class, ".toString()");
    }
}

