/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.collections;

import java.util.Calendar;
import java.util.Date;
import javax.annotation.Nullable;

public final class ColQueryFunctions {
    public static <A extends Comparable<? super A>> boolean between(A a, A b, A c) {
        return a.compareTo(b) >= 0 && a.compareTo(c) <= 0;
    }

    @Nullable
    public static <T> T coalesce(T ... args) {
        for (T arg : args) {
            if (arg == null) continue;
            return arg;
        }
        return null;
    }

    public static int getDayOfMonth(Date date) {
        return ColQueryFunctions.getField(date, 5);
    }

    public static int getDayOfWeek(Date date) {
        return ColQueryFunctions.getField(date, 7);
    }

    public static int getDayOfYear(Date date) {
        return ColQueryFunctions.getField(date, 6);
    }

    private static int getField(Date date, int field) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(field);
    }

    public static int getHour(Date date) {
        return ColQueryFunctions.getField(date, 11);
    }

    public static int getMilliSecond(Date date) {
        return ColQueryFunctions.getField(date, 14);
    }

    public static int getMinute(Date date) {
        return ColQueryFunctions.getField(date, 12);
    }

    public static int getMonth(Date date) {
        return ColQueryFunctions.getField(date, 2) + 1;
    }

    public static int getSecond(Date date) {
        return ColQueryFunctions.getField(date, 13);
    }

    public static int getWeek(Date date) {
        return ColQueryFunctions.getField(date, 3);
    }

    public static int getYear(Date date) {
        return ColQueryFunctions.getField(date, 1);
    }

    public static int getYearMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1) * 100 + cal.get(2) + 1;
    }

    public static boolean like(String str, String like) {
        return str.matches(like.replace("%", ".*").replace('_', '.'));
    }

    private ColQueryFunctions() {
    }
}

