/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.collections;

import com.mysema.codegen.Evaluator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.query.JoinExpression;
import com.mysema.query.JoinType;
import com.mysema.query.QueryMetadata;
import com.mysema.query.collections.DefaultEvaluatorFactory;
import com.mysema.query.collections.EvaluatorTransformer;
import com.mysema.query.collections.QueryEngine;
import com.mysema.query.types.Expr;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Order;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.expr.EArrayConstructor;
import com.mysema.util.MultiComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections15.IteratorUtils;

public class DefaultQueryEngine
implements QueryEngine {
    private final DefaultEvaluatorFactory evaluatorFactory;

    public DefaultQueryEngine(DefaultEvaluatorFactory evaluatorFactory) {
        this.evaluatorFactory = evaluatorFactory;
    }

    @Override
    public long count(QueryMetadata metadata, Map<Expr<?>, Iterable<?>> iterables) {
        if (metadata.getJoins().size() == 1) {
            return this.evaluateSingleSource(metadata, iterables, true).size();
        }
        return this.evaluateMultipleSources(metadata, iterables, true).size();
    }

    @Override
    public <T> List<T> list(QueryMetadata metadata, Map<Expr<?>, Iterable<?>> iterables, Expr<T> projection) {
        if (metadata.getJoins().size() == 1) {
            return this.evaluateSingleSource(metadata, iterables, false);
        }
        return this.evaluateMultipleSources(metadata, iterables, false);
    }

    private List<?> distinct(List<?> list) {
        if (!list.isEmpty() && list.get(0).getClass().isArray()) {
            HashSet<List<Object>> set = new HashSet<List<Object>>(list.size());
            ArrayList rv = new ArrayList(list.size());
            for (Object o : list) {
                if (!set.add(Arrays.asList((Object[])o))) continue;
                rv.add(o);
            }
            return rv;
        }
        return new ArrayList(new HashSet(list));
    }

    private List evaluateMultipleSources(QueryMetadata metadata, Map<Expr<?>, Iterable<?>> iterables, boolean count) {
        Evaluator<List<Object[]>> ev = this.evaluatorFactory.createEvaluator(metadata, metadata.getJoins(), metadata.getWhere());
        ArrayList iterableList = new ArrayList(metadata.getJoins().size());
        for (JoinExpression join : metadata.getJoins()) {
            if (join.getType() != JoinType.DEFAULT) continue;
            iterableList.add(iterables.get(join.getTarget()));
        }
        List<?> list = (List<?>)ev.evaluate(iterableList.toArray());
        if (!count && !list.isEmpty()) {
            ArrayList sources = new ArrayList();
            for (JoinExpression join : metadata.getJoins()) {
                if (join.getType() == JoinType.DEFAULT) {
                    sources.add(join.getTarget());
                    continue;
                }
                Operation target = (Operation)join.getTarget();
                sources.add(target.getArg(1));
            }
            if (!metadata.getOrderBy().isEmpty()) {
                this.order(metadata, sources, list);
            }
            if (metadata.getModifiers().isRestricting()) {
                list = metadata.getModifiers().subList(list);
            }
            if (list.isEmpty()) {
                return list;
            }
            list = this.project(metadata, sources, list);
        }
        if (metadata.isDistinct()) {
            list = this.distinct(list);
        }
        return list;
    }

    private List evaluateSingleSource(QueryMetadata metadata, Map<Expr<?>, Iterable<?>> iterables, boolean count) {
        Expr source = ((JoinExpression)metadata.getJoins().get(0)).getTarget();
        List<Expr<?>> sources = Collections.singletonList(source);
        Iterable<?> iterable = iterables.values().iterator().next();
        List<Object> list = iterable instanceof List ? (List<?>)iterable : IteratorAdapter.asList(iterable.iterator());
        if (metadata.getWhere() != null) {
            Evaluator evaluator = this.evaluatorFactory.createEvaluator(metadata, source, metadata.getWhere());
            list = (List<?>)evaluator.evaluate(new Object[]{list});
        }
        if (!count && !list.isEmpty()) {
            if (!metadata.getOrderBy().isEmpty()) {
                if (list == iterable) {
                    list = new ArrayList(list);
                }
                this.order(metadata, sources, list);
            }
            if (metadata.getModifiers().isRestricting()) {
                list = metadata.getModifiers().subList(list);
            }
            if (list.isEmpty()) {
                return list;
            }
            if (metadata.getProjection().size() > 1 || !((Expr)metadata.getProjection().get(0)).equals((Object)source)) {
                list = this.project(metadata, sources, list);
            }
        }
        if (metadata.isDistinct()) {
            list = this.distinct(list);
        }
        return list;
    }

    private void order(QueryMetadata metadata, List<Expr<?>> sources, List<?> list) {
        List orderBy = metadata.getOrderBy();
        Expr[] orderByExpr = new Expr[orderBy.size()];
        boolean[] directions = new boolean[orderBy.size()];
        for (int i = 0; i < orderBy.size(); ++i) {
            orderByExpr[i] = ((OrderSpecifier)orderBy.get(i)).getTarget();
            directions[i] = ((OrderSpecifier)orderBy.get(i)).getOrder() == Order.ASC;
        }
        EArrayConstructor expr = new EArrayConstructor(Object[].class, orderByExpr);
        Evaluator orderEvaluator = this.evaluatorFactory.create(metadata, (List<? extends Expr<?>>)sources, expr);
        Collections.sort(list, new MultiComparator(orderEvaluator, directions));
    }

    private List<?> project(QueryMetadata metadata, List<Expr<?>> sources, List<?> list) {
        Evaluator projectionEvaluator = this.evaluatorFactory.create(metadata, sources, (Expr)metadata.getProjection().get(0));
        EvaluatorTransformer transformer = new EvaluatorTransformer(projectionEvaluator);
        list = IteratorUtils.toList((Iterator)IteratorUtils.transformedIterator(list.iterator(), transformer));
        return list;
    }
}

