/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.collections.impl;

import com.mysema.query.collections.ColQueryTemplates;
import com.mysema.query.collections.impl.ColQuerySerializer;
import com.mysema.query.collections.impl.Evaluator;
import com.mysema.query.types.expr.Expr;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.codehaus.janino.CompileException;
import org.codehaus.janino.ExpressionEvaluator;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class EvaluatorFactory {
    private static final Logger logger = LoggerFactory.getLogger(EvaluatorFactory.class);
    private final ColQueryTemplates templates;

    public EvaluatorFactory(ColQueryTemplates templates) {
        this.templates = templates;
    }

    public <T> Evaluator<T> create(List<? extends Expr<?>> sources, Expr<T> projection) {
        ColQuerySerializer serializer = new ColQuerySerializer(this.templates);
        serializer.handle(projection);
        Map constantToLabel = serializer.getConstantToLabel();
        final String javaSource = serializer.toString();
        final Object[] constArray = constantToLabel.keySet().toArray();
        Class[] types = new Class[constArray.length + sources.size()];
        final String[] names = new String[constArray.length + sources.size()];
        for (int i = 0; i < constArray.length; ++i) {
            types[i] = List.class.isAssignableFrom(constArray[i].getClass()) ? List.class : (Set.class.isAssignableFrom(constArray[i].getClass()) ? Set.class : (Collection.class.isAssignableFrom(constArray[i].getClass()) ? Collection.class : constArray[i].getClass()));
            names[i] = (String)constantToLabel.get(constArray[i]);
        }
        int off = constArray.length;
        for (int i = 0; i < sources.size(); ++i) {
            types[off + i] = sources.get(i).getType();
            names[off + i] = sources.get(i).toString();
        }
        if (logger.isInfoEnabled()) {
            logger.info(javaSource + " " + Arrays.asList(names) + " " + Arrays.asList(types));
        }
        try {
            final ExpressionEvaluator evaluator = new ExpressionEvaluator(javaSource, projection.getType(), names, types);
            return new Evaluator<T>(){

                @Override
                public T evaluate(Object ... args) {
                    try {
                        args = EvaluatorFactory.combine(constArray.length + args.length, new Object[][]{constArray, args});
                        return evaluator.evaluate(args);
                    }
                    catch (InvocationTargetException e) {
                        StringBuilder builder = new StringBuilder();
                        builder.append("Caught exception when evaluating '").append(javaSource);
                        builder.append("' with arguments ");
                        for (int i = 0; i < args.length; ++i) {
                            builder.append(names[i]).append(" = ").append(args[i]);
                            if (i >= args.length - 1) continue;
                            builder.append(", ");
                        }
                        throw new RuntimeException(builder.toString(), e);
                    }
                }
            };
        }
        catch (CompileException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Parser.ParseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Scanner.ScanException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static Object[] combine(int size, Object[] ... arrays) {
        int offset = 0;
        Object[] target = new Object[size];
        for (Object[] arr : arrays) {
            System.arraycopy(arr, 0, target, offset, arr.length);
            offset += arr.length;
        }
        return target;
    }
}

