/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import javax.annotation.Nullable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;

public class TypeExtractor {
    private final boolean skipPrimitive;
    private final boolean skipEnum;

    public TypeExtractor(boolean skipPrimitive, boolean skipEnum) {
        this.skipPrimitive = skipPrimitive;
        this.skipEnum = skipEnum;
    }

    @Nullable
    public TypeElement handle(TypeMirror typeMirror) {
        if (typeMirror instanceof DeclaredType) {
            return this.handleDeclaredType((DeclaredType)typeMirror);
        }
        if (typeMirror instanceof TypeVariable) {
            return this.handleTypeVariable((TypeVariable)typeMirror);
        }
        if (typeMirror instanceof WildcardType) {
            return this.handleWildcard((WildcardType)typeMirror);
        }
        if (typeMirror instanceof ArrayType) {
            ArrayType t = (ArrayType)typeMirror;
            return this.handle(t.getComponentType());
        }
        if (typeMirror instanceof NoType) {
            return null;
        }
        return null;
    }

    @Nullable
    private TypeElement handleDeclaredType(DeclaredType typeMirror) {
        if (typeMirror.asElement() instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)typeMirror.asElement();
            switch (typeElement.getKind()) {
                case ENUM: {
                    return this.handleEnumType(typeMirror, typeElement);
                }
                case CLASS: {
                    return this.handleClassType(typeMirror, typeElement);
                }
                case INTERFACE: {
                    return this.handleInterfaceType(typeMirror, typeElement);
                }
            }
            throw new IllegalArgumentException("Illegal type " + typeElement);
        }
        return null;
    }

    @Nullable
    private TypeElement handleWildcard(WildcardType typeMirror) {
        return this.handle(typeMirror.getExtendsBound());
    }

    @Nullable
    private TypeElement handleTypeVariable(TypeVariable typeMirror) {
        if (typeMirror.getUpperBound() != null) {
            return this.handle(typeMirror.getUpperBound());
        }
        return this.handle(typeMirror.getLowerBound());
    }

    @Nullable
    private TypeElement handleInterfaceType(DeclaredType typeMirror, TypeElement typeElement) {
        return this.handle(typeMirror.getTypeArguments().get(typeMirror.getTypeArguments().size() - 1));
    }

    @Nullable
    private TypeElement handleClassType(DeclaredType typeMirror, TypeElement typeElement) {
        if (this.skipPrimitive && typeMirror.getKind().isPrimitive()) {
            return null;
        }
        return typeElement;
    }

    @Nullable
    private TypeElement handleEnumType(DeclaredType typeMirror, TypeElement typeElement) {
        if (this.skipEnum) {
            return null;
        }
        return typeElement;
    }
}

