/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt.plugin;

import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractProcessorMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File outputDirectory;
    protected String[] processors;
    protected String processor;

    private String buildCompileClasspath() {
        List pathElements = null;
        try {
            pathElements = this.isForTest() ? this.project.getTestClasspathElements() : this.project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            super.getLog().warn((CharSequence)"exception calling getCompileClasspathElements", (Throwable)e);
            return null;
        }
        if (pathElements.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        for (i = 0; i < pathElements.size() - 1; ++i) {
            result.append((String)pathElements.get(i)).append(File.pathSeparatorChar);
        }
        result.append((String)pathElements.get(i));
        return result.toString();
    }

    private String buildProcessor() {
        if (this.processors != null) {
            StringBuilder result = new StringBuilder();
            int i = 0;
            for (i = 0; i < this.processors.length - 1; ++i) {
                result.append(this.processors[i]).append(',');
            }
            result.append(this.processors[i]);
            return result.toString();
        }
        if (this.processor != null) {
            return this.processor;
        }
        String error = "Either processor or processors need to be given";
        this.getLog().error((CharSequence)error);
        throw new IllegalArgumentException(error);
    }

    public void execute() throws MojoExecutionException {
        if (this.outputDirectory != null && !this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        try {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
            List files = FileUtils.getFiles((File)this.getSourceDirectory(), (String)"**/*.java", null);
            Iterable<? extends JavaFileObject> compilationUnits1 = fileManager.getJavaFileObjectsFromFiles(files);
            String compileClassPath = this.buildCompileClasspath();
            String processor = this.buildProcessor();
            ArrayList<String> options = new ArrayList<String>(10);
            options.add("-cp");
            options.add(compileClassPath);
            options.add("-proc:only");
            options.add("-processor");
            options.add(processor);
            if (this.outputDirectory != null) {
                options.add("-s");
                options.add(this.outputDirectory.getPath());
            }
            StringWriter writer = new StringWriter();
            JavaCompiler.CompilationTask task = compiler.getTask(writer, fileManager, null, options, null, compilationUnits1);
            task.call();
            FileUtils.fileWrite((String)new File(this.project.getBasedir(), "target/apt-log").getAbsolutePath(), (String)((Object)writer).toString());
            if (this.outputDirectory != null) {
                if (this.isForTest()) {
                    this.project.addTestCompileSourceRoot(this.outputDirectory.getAbsolutePath());
                } else {
                    this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
                }
            }
        }
        catch (Exception e1) {
            super.getLog().error((CharSequence)"execute error", (Throwable)e1);
            throw new MojoExecutionException(e1.getMessage());
        }
    }

    protected abstract File getSourceDirectory();

    protected boolean isForTest() {
        return false;
    }
}

