/*
 * Decompiled with CFR 0.152.
 */
package com.myscript.iink.text;

import java.util.ArrayList;

public class Text {
    private final String label;
    private final int[] ends;

    Text(String label, int[] ends) {
        this.label = label;
        this.ends = ends;
    }

    public final String getLabel() {
        return this.label;
    }

    public final int getGlyphCount() {
        return this.ends.length;
    }

    public final int getGlyphCount(int beginIndex, int endIndex) {
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("beginIndex should be <= endIndex");
        }
        ArrayList<Integer> list = new ArrayList<Integer>(this.ends.length);
        for (int i : this.ends) {
            list.add(i);
        }
        int indexEndGlyph = list.indexOf(endIndex + 1);
        if (indexEndGlyph == -1) {
            throw new IllegalArgumentException("ending byte not in the end of a glyph");
        }
        int indexBeginGlyph = 0;
        if (beginIndex != 0) {
            indexBeginGlyph = list.indexOf(beginIndex);
            if (indexBeginGlyph == -1) {
                throw new IllegalArgumentException("beginning byte not in the beginning of a glyph");
            }
            ++indexBeginGlyph;
        }
        return indexEndGlyph - indexBeginGlyph + 1;
    }

    public final int getGlyphBeginAt(int index) {
        if (index < 0 || index >= this.ends.length) {
            throw new IndexOutOfBoundsException();
        }
        return index == 0 ? 0 : this.ends[index - 1];
    }

    public final int getGlyphEndAt(int index) {
        if (index < 0 || index >= this.ends.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.ends[index];
    }

    public final String getGlyphLabelAt(int index) {
        if (index < 0 || index >= this.ends.length) {
            throw new IndexOutOfBoundsException();
        }
        return index == 0 ? this.label.substring(0, this.ends[0]) : this.label.substring(this.ends[index - 1], this.ends[index]);
    }
}

