/*
 * Decompiled with CFR 0.152.
 */
package com.myscript.iink.graphics;

import com.myscript.iink.graphics.Point;
import com.myscript.util.Numbers;

public class Transform {
    public double xx;
    public double yx;
    public double tx;
    public double xy;
    public double yy;
    public double ty;

    public Transform(double xx, double yx, double tx, double xy, double yy, double ty) {
        this.xx = xx;
        this.yx = yx;
        this.tx = tx;
        this.xy = xy;
        this.yy = yy;
        this.ty = ty;
    }

    public Transform() {
        this(1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    public Transform(Transform other) {
        this(other.xx, other.yx, other.tx, other.xy, other.yy, other.ty);
    }

    public final boolean isNear(Transform other) {
        return Numbers.isNear(this.xx, other.xx) && Numbers.isNear(this.yx, other.yx) && Numbers.isNear(this.tx, other.tx) && Numbers.isNear(this.xy, other.xy) && Numbers.isNear(this.yy, other.yy) && Numbers.isNear(this.ty, other.ty);
    }

    public final void invert() {
        double a = this.xx;
        double b = this.yx;
        double c = this.tx;
        double d = this.xy;
        double e = this.yy;
        double f = this.ty;
        double ae = a * e;
        double bd = b * d;
        double x = ae - bd;
        if (Math.abs(x) < 1.0E-10) {
            throw new IllegalStateException("non invertible matrix");
        }
        this.xx = e / x;
        this.yx = -b / x;
        this.tx = (b * f - c * e) / x;
        this.xy = -d / x;
        this.yy = a / x;
        this.ty = -(a * f - c * d) / x;
    }

    public final void multiply(Transform other) {
        this.multiply(other.xx, other.yx, other.tx, other.xy, other.yy, other.ty);
    }

    public final void multiply(double xx, double yx, double tx, double xy, double yy, double ty) {
        double xx_ = this.xx * xx + this.yx * xy;
        double yx_ = this.xx * yx + this.yx * yy;
        double tx_ = this.xx * tx + this.yx * ty + this.tx;
        double xy_ = this.xy * xx + this.yy * xy;
        double yy_ = this.xy * yx + this.yy * yy;
        double ty_ = this.xy * tx + this.yy * ty + this.ty;
        this.xx = xx_;
        this.yx = yx_;
        this.tx = tx_;
        this.xy = xy_;
        this.yy = yy_;
        this.ty = ty_;
    }

    private final void multiply_XY(double xx, double yx, double xy, double yy) {
        double xx_ = this.xx * xx + this.yx * xy;
        double yx_ = this.xx * yx + this.yx * yy;
        double xy_ = this.xy * xx + this.yy * xy;
        double yy_ = this.xy * yx + this.yy * yy;
        this.xx = xx_;
        this.yx = yx_;
        this.xy = xy_;
        this.yy = yy_;
    }

    private final void multiply_T(double tx, double ty) {
        double tx_ = this.xx * tx + this.yx * ty + this.tx;
        double ty_ = this.xy * tx + this.yy * ty + this.ty;
        this.tx = tx_;
        this.ty = ty_;
    }

    public final void translate(double tx, double ty) {
        this.multiply_T(tx, ty);
    }

    public final void scale(double s) {
        this.multiply_XY(s, 0.0, 0.0, s);
    }

    public final void scale(double sx, double sy) {
        this.multiply_XY(sx, 0.0, 0.0, sy);
    }

    public final void rotate(double a) {
        this.rotate(Math.cos(a), Math.sin(a));
    }

    public final void rotate(double a, double x0, double y0) {
        this.rotate(Math.cos(a), Math.sin(a), x0, y0);
    }

    public final void rotate(double cosA, double sinA) {
        this.multiply_XY(cosA, -sinA, sinA, cosA);
    }

    public final void rotate(double cosA, double sinA, double x0, double y0) {
        this.multiply(cosA, -sinA, -cosA * x0 + sinA * y0 + x0, sinA, cosA, -sinA * x0 - cosA * y0 + y0);
    }

    public final Point apply(float x, float y) {
        return new Point((float)((double)x * this.xx + (double)y * this.yx + this.tx), (float)((double)x * this.xy + (double)y * this.yy + this.ty));
    }

    public final void apply(Point p) {
        float x = (float)((double)p.x * this.xx + (double)p.y * this.yx + this.tx);
        float y = (float)((double)p.x * this.xy + (double)p.y * this.yy + this.ty);
        p.x = x;
        p.y = y;
    }

    public final void apply(Point[] points) {
        this.apply(points, 0, points.length);
    }

    public final void apply(Point[] points, int offset, int count) {
        for (int i = 0; i < count; ++i) {
            this.apply(points[offset + i]);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Transform)) {
            return false;
        }
        Transform other = (Transform)obj;
        return this.xx == other.xx && this.yx == other.yx && this.tx == other.tx && this.xy == other.xy && this.yy == other.yy && this.ty == other.ty;
    }

    public int hashCode() {
        return Numbers.hashCode(this.xx) ^ Numbers.hashCode(this.yx) ^ Numbers.hashCode(this.tx) ^ Numbers.hashCode(this.xy) ^ Numbers.hashCode(this.yy) ^ Numbers.hashCode(this.ty);
    }

    public final String toString() {
        return String.format("Transform(%g, %g, %g, %g, %g, %g)", this.xx, this.xy, this.yx, this.yy, this.tx, this.ty);
    }
}

