/*
 * Decompiled with CFR 0.152.
 */
package com.myscript.iink.graphics;

import com.myscript.iink.graphics.Color;
import com.myscript.iink.graphics.FillRule;
import com.myscript.iink.graphics.ICanvas;
import com.myscript.iink.graphics.LineCap;
import com.myscript.iink.graphics.LineJoin;
import com.myscript.iink.graphics.StyleFlag;
import com.myscript.util.Numbers;
import java.util.Arrays;
import java.util.EnumSet;

public class Style {
    protected Color strokeColor;
    protected float strokeWidth;
    protected LineCap strokeLineCap;
    protected LineJoin strokeLineJoin;
    protected float strokeMiterLimit;
    protected float[] strokeDashArray;
    protected float strokeDashOffset;
    protected Color fillColor;
    protected FillRule fillRule;
    protected String fontFamily;
    protected float fontLineHeight;
    protected float fontSize;
    protected String fontStyle;
    protected String fontVariant;
    protected int fontWeight;
    protected EnumSet<StyleFlag> changeFlags;

    public Style() {
        this.clear();
    }

    public Style(Style other) {
        this.strokeColor = other.strokeColor;
        this.strokeWidth = other.strokeWidth;
        this.strokeLineCap = other.strokeLineCap;
        this.strokeLineJoin = other.strokeLineJoin;
        this.strokeMiterLimit = other.strokeMiterLimit;
        this.strokeDashArray = other.strokeDashArray;
        this.strokeDashOffset = other.strokeDashOffset;
        this.fillColor = other.fillColor;
        this.fillRule = other.fillRule;
        this.fontFamily = other.fontFamily;
        this.fontLineHeight = other.fontLineHeight;
        this.fontSize = other.fontSize;
        this.fontStyle = other.fontStyle;
        this.fontVariant = other.fontVariant;
        this.fontWeight = other.fontWeight;
        this.changeFlags = EnumSet.copyOf(other.changeFlags);
    }

    public void clear() {
        this.strokeColor = Color.NONE;
        this.strokeWidth = 1.0f;
        this.strokeLineCap = LineCap.BUTT;
        this.strokeLineJoin = LineJoin.MITER;
        this.strokeMiterLimit = 4.0f;
        this.strokeDashArray = null;
        this.strokeDashOffset = 0.0f;
        this.fillColor = Color.BLACK;
        this.fillRule = FillRule.NONZERO;
        this.fontFamily = "sans-serif";
        this.fontLineHeight = 1.2f;
        this.fontSize = 10.0f;
        this.fontStyle = "normal";
        this.fontVariant = "normal";
        this.fontWeight = 400;
        this.changeFlags = EnumSet.noneOf(StyleFlag.class);
    }

    public void setStrokeColor(Color strokeColor) {
        if (!this.strokeColor.equals(strokeColor)) {
            this.strokeColor = strokeColor;
            this.changeFlags.add(StyleFlag.STROKE_COLOR);
        }
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeWidth(float strokeWidth) {
        if (this.strokeWidth != strokeWidth) {
            this.strokeWidth = strokeWidth;
            this.changeFlags.add(StyleFlag.STROKE_WIDTH);
        }
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeLineCap(LineCap strokeLineCap) {
        if (this.strokeLineCap != strokeLineCap) {
            this.strokeLineCap = strokeLineCap;
            this.changeFlags.add(StyleFlag.STROKE_LINE_CAP);
        }
    }

    public LineCap getStrokeLineCap() {
        return this.strokeLineCap;
    }

    public void setStrokeLineJoin(LineJoin strokeLineJoin) {
        if (this.strokeLineJoin != strokeLineJoin) {
            this.strokeLineJoin = strokeLineJoin;
            this.changeFlags.add(StyleFlag.STROKE_LINE_JOIN);
        }
    }

    public LineJoin getStrokeLineJoin() {
        return this.strokeLineJoin;
    }

    public void setStrokeMiterLimit(float strokeMiterLimit) {
        if (this.strokeMiterLimit != strokeMiterLimit) {
            this.strokeMiterLimit = strokeMiterLimit;
            this.changeFlags.add(StyleFlag.STROKE_MITER_LIMIT);
        }
    }

    public float getStrokeMiterLimit() {
        return this.strokeMiterLimit;
    }

    public void setStrokeDashArray(float[] strokeDashArray) {
        if (this.strokeDashArray == null && strokeDashArray != null || this.strokeDashArray != null && strokeDashArray == null || this.strokeDashArray != null && strokeDashArray != null && !Arrays.equals(this.strokeDashArray, strokeDashArray)) {
            this.strokeDashArray = strokeDashArray;
            this.changeFlags.add(StyleFlag.STROKE_DASH_ARRAY);
        }
    }

    public float[] getStrokeDashArray() {
        return this.strokeDashArray;
    }

    public void setStrokeDashOffset(float strokeDashOffset) {
        if (this.strokeDashOffset != strokeDashOffset) {
            this.strokeDashOffset = strokeDashOffset;
            this.changeFlags.add(StyleFlag.STROKE_DASH_OFFSET);
        }
    }

    public float getStrokeDashOffset() {
        return this.strokeDashOffset;
    }

    public void setFillColor(Color fillColor) {
        if (!this.fillColor.equals(fillColor)) {
            this.fillColor = fillColor;
            this.changeFlags.add(StyleFlag.FILL_COLOR);
        }
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillRule(FillRule fillRule) {
        if (this.fillRule != fillRule) {
            this.fillRule = fillRule;
            this.changeFlags.add(StyleFlag.FILL_RULE);
        }
    }

    public FillRule getFillRule() {
        return this.fillRule;
    }

    public void setFontFamily(String fontFamily) {
        if (!this.fontFamily.equals(fontFamily)) {
            this.fontFamily = fontFamily;
            this.changeFlags.add(StyleFlag.FONT_FAMILY);
        }
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontLineHeight(float fontLineHeight) {
        if (this.fontLineHeight != fontLineHeight) {
            this.fontLineHeight = fontLineHeight;
            this.changeFlags.add(StyleFlag.FONT_LINE_HEIGHT);
        }
    }

    public float getFontLineHeight() {
        return this.fontLineHeight;
    }

    public void setFontSize(float fontSize) {
        if (this.fontSize != fontSize) {
            this.fontSize = fontSize;
            this.changeFlags.add(StyleFlag.FONT_SIZE);
        }
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontStyle(String fontStyle) {
        if (!this.fontStyle.equals(fontStyle)) {
            this.fontStyle = fontStyle;
            this.changeFlags.add(StyleFlag.FONT_STYLE);
        }
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontVariant(String fontVariant) {
        if (!this.fontVariant.equals(fontVariant)) {
            this.fontVariant = fontVariant;
            this.changeFlags.add(StyleFlag.FONT_VARIANT);
        }
    }

    public String getFontVariant() {
        return this.fontVariant;
    }

    public void setFontWeight(int fontWeight) {
        if (this.fontWeight != fontWeight) {
            this.fontWeight = fontWeight;
            this.changeFlags.add(StyleFlag.FONT_WEIGHT);
        }
    }

    public int getFontWeight() {
        return this.fontWeight;
    }

    public EnumSet<StyleFlag> getChangeFlags() {
        return EnumSet.copyOf(this.changeFlags);
    }

    public void clearChangeFlags() {
        this.changeFlags.clear();
    }

    public void applyTo(ICanvas canvas) {
        if (this.changeFlags.isEmpty()) {
            return;
        }
        if (this.changeFlags.contains((Object)StyleFlag.STROKE_COLOR)) {
            canvas.setStrokeColor(this.strokeColor);
        }
        if (this.changeFlags.contains((Object)StyleFlag.STROKE_WIDTH)) {
            canvas.setStrokeWidth(this.strokeWidth);
        }
        if (this.changeFlags.contains((Object)StyleFlag.STROKE_LINE_CAP)) {
            canvas.setStrokeLineCap(this.strokeLineCap);
        }
        if (this.changeFlags.contains((Object)StyleFlag.STROKE_LINE_JOIN)) {
            canvas.setStrokeLineJoin(this.strokeLineJoin);
        }
        if (this.changeFlags.contains((Object)StyleFlag.STROKE_MITER_LIMIT)) {
            canvas.setStrokeMiterLimit(this.strokeMiterLimit);
        }
        if (this.changeFlags.contains((Object)StyleFlag.STROKE_DASH_ARRAY)) {
            canvas.setStrokeDashArray(this.strokeDashArray);
        }
        if (this.changeFlags.contains((Object)StyleFlag.STROKE_DASH_OFFSET)) {
            canvas.setStrokeDashOffset(this.strokeDashOffset);
        }
        if (this.changeFlags.contains((Object)StyleFlag.FILL_COLOR)) {
            canvas.setFillColor(this.fillColor);
        }
        if (this.changeFlags.contains((Object)StyleFlag.FILL_RULE)) {
            canvas.setFillRule(this.fillRule);
        }
        if (this.changeFlags.contains((Object)StyleFlag.FONT_FAMILY) || this.changeFlags.contains((Object)StyleFlag.FONT_LINE_HEIGHT) || this.changeFlags.contains((Object)StyleFlag.FONT_SIZE) || this.changeFlags.contains((Object)StyleFlag.FONT_STYLE) || this.changeFlags.contains((Object)StyleFlag.FONT_VARIANT) || this.changeFlags.contains((Object)StyleFlag.FONT_WEIGHT)) {
            canvas.setFontProperties(this.fontFamily, this.fontLineHeight, this.fontSize, this.fontStyle, this.fontVariant, this.fontWeight);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Style)) {
            return false;
        }
        Style other = (Style)obj;
        return this.strokeColor == other.strokeColor && this.strokeWidth == other.strokeWidth && this.strokeLineCap == other.strokeLineCap && this.strokeLineJoin == other.strokeLineJoin && this.strokeMiterLimit == other.strokeMiterLimit && this.strokeDashArray == other.strokeDashArray && this.strokeDashOffset == other.strokeDashOffset && this.fillColor == other.fillColor && this.fillRule == other.fillRule && this.fontFamily == other.fontFamily && this.fontLineHeight == other.fontLineHeight && this.fontSize == other.fontSize && this.fontStyle == other.fontStyle && this.fontVariant == other.fontVariant && this.fontWeight == other.fontWeight;
    }

    public int hashCode() {
        return this.strokeColor.hashCode() ^ Numbers.hashCode(this.strokeWidth) ^ this.strokeLineCap.hashCode() ^ this.strokeLineJoin.hashCode() ^ Numbers.hashCode(this.strokeMiterLimit) ^ Arrays.hashCode(this.strokeDashArray) ^ Numbers.hashCode(this.strokeDashOffset) ^ this.fillColor.hashCode() ^ this.fillRule.hashCode() ^ this.fontFamily.hashCode() ^ Numbers.hashCode(this.fontLineHeight) ^ Numbers.hashCode(this.fontSize) ^ this.fontStyle.hashCode() ^ this.fontVariant.hashCode() ^ Numbers.hashCode(this.fontWeight);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "( strokeColor=" + this.strokeColor + ", strokeWidth=" + this.strokeWidth + ", strokeLineCap=" + (Object)((Object)this.strokeLineCap) + ", strokeLineJoin=" + (Object)((Object)this.strokeLineJoin) + ", strokeMiterLimit=" + this.strokeMiterLimit + ", strokeDashArray=" + this.strokeDashArray + ", strokeDashOffset=" + this.strokeDashOffset + ", fillColor=" + this.fillColor + ", fillRule=" + (Object)((Object)this.fillRule) + ", fontFamily=" + this.fontFamily + ", fontLineHeight=" + this.fontLineHeight + ", fontSize=" + this.fontSize + ", fontStyle=" + this.fontStyle + ", fontVariant=" + this.fontVariant + ", fontWeight=" + this.fontWeight + ")";
    }
}

