/*
 * Decompiled with CFR 0.152.
 */
package com.myscript.iink;

import com.myscript.iink.NativeFunctions;
import com.myscript.util.IAutoCloseable;

public class ParameterSet
implements IAutoCloseable {
    long nativeRef;

    ParameterSet(long nativeRef) {
        this.nativeRef = nativeRef;
    }

    @Override
    public final void close() {
        if (this.nativeRef != 0L) {
            NativeFunctions.destroyParameterSet(this.nativeRef);
            this.nativeRef = 0L;
        }
    }

    public final boolean isClosed() {
        return this.nativeRef == 0L;
    }

    protected final void checkNotClosed() {
        if (this.nativeRef == 0L) {
            throw new IllegalStateException(this.getClass().getName() + " closed");
        }
    }

    public final ParameterSet getSection(String key) {
        this.checkNotClosed();
        return new ParameterSet(NativeFunctions.getSection(this.nativeRef, key));
    }

    public final String getString(String key) {
        this.checkNotClosed();
        return NativeFunctions.getString(this.nativeRef, key);
    }

    public final String getString(String key, String defaultValue) {
        this.checkNotClosed();
        return NativeFunctions.getString2(this.nativeRef, key, defaultValue);
    }

    public final void setString(String key, String value) {
        this.checkNotClosed();
        NativeFunctions.setString(this.nativeRef, key, value);
    }

    public final Boolean getBoolean(String key) {
        this.checkNotClosed();
        return NativeFunctions.getBoolean(this.nativeRef, key);
    }

    public final Boolean getBoolean(String key, boolean defaultValue) {
        this.checkNotClosed();
        return NativeFunctions.getBoolean2(this.nativeRef, key, defaultValue);
    }

    public final void setBoolean(String key, Boolean value) {
        this.checkNotClosed();
        NativeFunctions.setBoolean(this.nativeRef, key, value);
    }

    public final Number getNumber(String key) {
        this.checkNotClosed();
        return NativeFunctions.getNumber(this.nativeRef, key);
    }

    public final Number getNumber(String key, Number defaultValue) {
        this.checkNotClosed();
        return NativeFunctions.getNumber2(this.nativeRef, key, defaultValue.doubleValue());
    }

    public final void setNumber(String key, Number value) {
        this.checkNotClosed();
        NativeFunctions.setNumber(this.nativeRef, key, value.doubleValue());
    }

    public final String[] getStringArray(String key) {
        this.checkNotClosed();
        return NativeFunctions.getStringArray(this.nativeRef, key);
    }

    public final void setStringArray(String key, String[] value) {
        this.checkNotClosed();
        NativeFunctions.setStringArray(this.nativeRef, key, value);
    }

    public final void inject(String json) {
        this.checkNotClosed();
        NativeFunctions.injectJson(this.nativeRef, json);
    }
}

