/*
 * Decompiled with CFR 0.152.
 */
package com.myscript.iink;

import com.myscript.iink.IRenderTarget;
import com.myscript.iink.graphics.IPath;
import java.util.EnumSet;
import java.util.Locale;

public class NativeLibrary {
    private static final void clinit() {
        String vm = System.getProperty("java.vm.name", "").toLowerCase(Locale.US);
        if (vm.equals("dalvik")) {
            System.loadLibrary("c++_shared");
        }
        System.loadLibrary("MyScriptEngine");
        System.loadLibrary("iink");
    }

    public static void init() {
    }

    static final int getPathUnsupportedOperations(IPath path) {
        EnumSet<IPath.OperationType> set = path.unsupportedOperations();
        int r = 0;
        if (set.contains((Object)IPath.OperationType.CURVE_OPS)) {
            r |= 1 << IPath.OperationType.CURVE_OPS.ordinal();
        }
        if (set.contains((Object)IPath.OperationType.QUAD_OPS)) {
            r |= 1 << IPath.OperationType.QUAD_OPS.ordinal();
        }
        if (set.contains((Object)IPath.OperationType.ARC_OPS)) {
            r |= 1 << IPath.OperationType.ARC_OPS.ordinal();
        }
        return r;
    }

    static final EnumSet<IRenderTarget.LayerType> getLayerSet(int flags) {
        EnumSet<IRenderTarget.LayerType> set = EnumSet.noneOf(IRenderTarget.LayerType.class);
        if ((flags & 1 << IRenderTarget.LayerType.BACKGROUND.ordinal()) != 0) {
            set.add(IRenderTarget.LayerType.BACKGROUND);
        }
        if ((flags & 1 << IRenderTarget.LayerType.MODEL.ordinal()) != 0) {
            set.add(IRenderTarget.LayerType.MODEL);
        }
        if ((flags & 1 << IRenderTarget.LayerType.TEMPORARY.ordinal()) != 0) {
            set.add(IRenderTarget.LayerType.TEMPORARY);
        }
        if ((flags & 1 << IRenderTarget.LayerType.CAPTURE.ordinal()) != 0) {
            set.add(IRenderTarget.LayerType.CAPTURE);
        }
        return set;
    }

    static {
        if (!"true".equals(System.getProperty("IINK_PREVENT_NATIVE_LIBS_LOADING"))) {
            NativeLibrary.clinit();
        }
    }
}

