/*
 * Decompiled with CFR 0.152.
 */
package com.myscript.iink;

import com.myscript.iink.Configuration;
import com.myscript.iink.ContentBlock;
import com.myscript.iink.ContentNode;
import com.myscript.iink.ContentPart;
import com.myscript.iink.ContentTree;
import com.myscript.iink.ConversionState;
import com.myscript.iink.Engine;
import com.myscript.iink.IEditorListener;
import com.myscript.iink.IEditorListener2;
import com.myscript.iink.IImageDrawer;
import com.myscript.iink.ListenerList;
import com.myscript.iink.MimeType;
import com.myscript.iink.NativeFunctions;
import com.myscript.iink.ParameterSet;
import com.myscript.iink.PointerEvent;
import com.myscript.iink.PointerType;
import com.myscript.iink.Renderer;
import com.myscript.iink.graphics.Point;
import com.myscript.iink.graphics.Style;
import com.myscript.iink.text.IFontMetricsProvider;
import com.myscript.util.IAutoCloseable;
import com.myscript.util.IPredicate;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Map;

public class Editor
implements IAutoCloseable {
    private Engine engine;
    private Renderer renderer;
    long nativeRef;
    private ContentPart part;
    private ListenerList<IEditorListener> listeners;
    private ContentTree contentTree;
    private Configuration configuration;

    Editor(Engine engine, Renderer renderer) {
        this.engine = engine;
        this.renderer = renderer;
        this.nativeRef = NativeFunctions.createEditor(engine.nativeRef, renderer.nativeRef, this);
        this.part = null;
        this.listeners = new ListenerList();
        this.contentTree = new ContentTree();
        this.configuration = new Configuration(NativeFunctions.getEditorConfiguration(this.nativeRef));
    }

    @Override
    public void close() {
        if (this.configuration != null) {
            this.configuration.close();
            this.configuration = null;
        }
        if (this.nativeRef != 0L) {
            NativeFunctions.destroyEditor(this.nativeRef);
            this.nativeRef = 0L;
        }
    }

    public final boolean isClosed() {
        return this.nativeRef == 0L;
    }

    private final void checkNotClosed() {
        if (this.nativeRef == 0L) {
            throw new IllegalStateException(this.getClass().getName() + " closed");
        }
    }

    public final void addListener(IEditorListener listener) {
        this.checkNotClosed();
        this.listeners.add(listener);
    }

    public final void removeListener(IEditorListener listener) {
        this.checkNotClosed();
        this.listeners.remove(listener);
    }

    public final void setFontMetricsProvider(IFontMetricsProvider fontMetricsProvider) {
        this.checkNotClosed();
        NativeFunctions.setFontMetricsProvider(this.nativeRef, fontMetricsProvider);
    }

    final void partChanging(final ContentPart oldPart, final ContentPart newPart) {
        this.listeners.forEach(new ListenerList.Consumer<IEditorListener>(){

            @Override
            public void accept(IEditorListener listener) {
                listener.partChanging(Editor.this, oldPart, newPart);
            }
        });
    }

    final void partChanged() {
        this.contentTree.setRoot(null);
        if (this.nativeRef != 0L) {
            this.contentTree.setRoot(NativeFunctions.createContentNodes(this.nativeRef, this.contentTree));
        }
        this.listeners.forEach(new ListenerList.Consumer<IEditorListener>(){

            @Override
            public void accept(IEditorListener listener) {
                listener.partChanged(Editor.this);
            }
        });
    }

    final void contentChanged(final String[] blockIds) {
        if (this.nativeRef != 0L) {
            this.contentTree.setRoot(NativeFunctions.createContentNodes(this.nativeRef, this.contentTree));
        }
        this.listeners.forEach(new ListenerList.Consumer<IEditorListener>(){

            @Override
            public void accept(IEditorListener listener) {
                listener.contentChanged(Editor.this, blockIds);
            }
        });
    }

    final void selectionChanged(final String[] blockIds) {
        this.listeners.forEach(new ListenerList.Consumer<IEditorListener>(){

            @Override
            public void accept(IEditorListener listener) {
                if (listener instanceof IEditorListener2) {
                    ((IEditorListener2)listener).selectionChanged(Editor.this, blockIds);
                }
            }
        });
    }

    final void activeBlockChanged(final String blockId) {
        if (this.nativeRef != 0L) {
            this.contentTree.setRoot(NativeFunctions.createContentNodes(this.nativeRef, this.contentTree));
        }
        this.listeners.forEach(new ListenerList.Consumer<IEditorListener>(){

            @Override
            public void accept(IEditorListener listener) {
                if (listener instanceof IEditorListener2) {
                    ((IEditorListener2)listener).activeBlockChanged(Editor.this, blockId);
                }
            }
        });
    }

    final void onError(final String blockId, final String message) {
        this.listeners.forEach(new ListenerList.Consumer<IEditorListener>(){

            @Override
            public void accept(IEditorListener listener) {
                listener.onError(Editor.this, blockId, message);
            }
        });
    }

    public final Engine getEngine() {
        return this.engine;
    }

    public final Renderer getRenderer() {
        return this.renderer;
    }

    public final ContentPart getPart() {
        return this.part;
    }

    public final void setPart(ContentPart part) {
        this.checkNotClosed();
        if (part != null) {
            part.checkNotClosed();
        }
        if (part == this.part) {
            return;
        }
        ContentPart oldPart = this.part;
        this.partChanging(oldPart, part);
        this.part = part;
        NativeFunctions.setPart(this.nativeRef, part == null ? 0L : part.nativeRef);
        this.partChanged();
    }

    public final void clear() {
        this.checkNotClosed();
        NativeFunctions.clear(this.nativeRef);
    }

    public final boolean canUndo() {
        this.checkNotClosed();
        return NativeFunctions.canUndo(this.nativeRef);
    }

    public final void undo() {
        this.checkNotClosed();
        NativeFunctions.undo(this.nativeRef);
    }

    public final boolean canRedo() {
        this.checkNotClosed();
        return NativeFunctions.canRedo(this.nativeRef);
    }

    public final void redo() {
        this.checkNotClosed();
        NativeFunctions.redo(this.nativeRef);
    }

    public final int getUndoStackIndex() {
        this.checkNotClosed();
        return NativeFunctions.getUndoStackIndex(this.nativeRef);
    }

    public final int getPossibleUndoCount() {
        this.checkNotClosed();
        return NativeFunctions.getPossibleUndoCount(this.nativeRef);
    }

    public final int getPossibleRedoCount() {
        this.checkNotClosed();
        return NativeFunctions.getPossibleRedoCount(this.nativeRef);
    }

    public final String getUndoRedoIdAt(int stackIndex) {
        this.checkNotClosed();
        return NativeFunctions.getUndoRedoIdAt(this.nativeRef, stackIndex);
    }

    public final String pointerDown(float x, float y, long t, float f, PointerType pointerType, int pointerId) {
        this.checkNotClosed();
        return NativeFunctions.pointerDown(this.nativeRef, x, y, t, f, pointerType.ordinal(), pointerId);
    }

    public final void pointerMove(float x, float y, long t, float f, PointerType pointerType, int pointerId) {
        this.checkNotClosed();
        NativeFunctions.pointerMove(this.nativeRef, x, y, t, f, pointerType.ordinal(), pointerId);
    }

    public final void pointerUp(float x, float y, long t, float f, PointerType pointerType, int pointerId) {
        this.checkNotClosed();
        NativeFunctions.pointerUp(this.nativeRef, x, y, t, f, pointerType.ordinal(), pointerId);
    }

    public final void pointerCancel(int pointerId) {
        this.checkNotClosed();
        NativeFunctions.pointerCancel(this.nativeRef, pointerId);
    }

    public final void pointerEvents(PointerEvent[] events, boolean processGestures) {
        this.checkNotClosed();
        NativeFunctions.pointerEvents(this.nativeRef, events, processGestures);
    }

    public final void setViewSize(int width, int height) {
        this.checkNotClosed();
        NativeFunctions.setViewSize(this.nativeRef, width, height);
    }

    public final int getViewWidth() {
        this.checkNotClosed();
        return NativeFunctions.getViewWidth(this.nativeRef);
    }

    public final int getViewHeight() {
        this.checkNotClosed();
        return NativeFunctions.getViewHeight(this.nativeRef);
    }

    public void clampViewOffset(Point viewOffset) {
        this.checkNotClosed();
        NativeFunctions.clampViewOffset(this.nativeRef, viewOffset);
    }

    public final void setTheme(String styleSheet) {
        this.checkNotClosed();
        NativeFunctions.setTheme(this.nativeRef, styleSheet);
    }

    public final String getTheme() {
        this.checkNotClosed();
        return NativeFunctions.getTheme(this.nativeRef);
    }

    public final void setPenStyleClasses(String styleClasses) {
        this.checkNotClosed();
        NativeFunctions.setPenStyleClasses(this.nativeRef, styleClasses);
    }

    public final String getPenStyleClasses() {
        this.checkNotClosed();
        return NativeFunctions.getPenStyleClasses(this.nativeRef);
    }

    public final void setPenStyle(String styleProperties) {
        this.checkNotClosed();
        NativeFunctions.setPenStyle(this.nativeRef, styleProperties);
    }

    public final String getPenStyle() {
        this.checkNotClosed();
        return NativeFunctions.getPenStyle(this.nativeRef);
    }

    public final Map<String, Style> listStyleClasses(IPredicate<String> predicate) {
        this.checkNotClosed();
        return NativeFunctions.listStyleClasses(this.nativeRef, predicate);
    }

    public final ContentBlock getRootBlock() {
        this.checkNotClosed();
        ContentNode node = this.contentTree.getRoot();
        return node == null ? null : new ContentBlock(this.part, node);
    }

    public final ContentBlock getBlockById(String id) {
        this.checkNotClosed();
        ContentNode node = this.contentTree.getNodeById(id);
        return node == null ? null : new ContentBlock(this.part, node);
    }

    public final boolean isEmpty(ContentBlock block) {
        this.checkNotClosed();
        return NativeFunctions.isEmpty(this.nativeRef, block == null ? null : block.getId());
    }

    public final String[] getSupportedAddBlockTypes() {
        this.checkNotClosed();
        return NativeFunctions.getSupportedAddBlockTypes(this.nativeRef);
    }

    public final MimeType[] getSupportedAddBlockDataMimeTypes(String type) {
        this.checkNotClosed();
        int[] ordinals = NativeFunctions.getSupportedAddBlockDataMimeTypes(this.nativeRef, type);
        MimeType[] mimeTypes = new MimeType[ordinals.length];
        for (int i = 0; i < mimeTypes.length; ++i) {
            mimeTypes[i] = MimeType.values()[ordinals[i]];
        }
        return mimeTypes;
    }

    public final ContentBlock addBlock(float x, float y, String blockType) {
        this.checkNotClosed();
        String id = NativeFunctions.addBlock(this.nativeRef, x, y, blockType, -1, "");
        ContentNode node = this.contentTree.getNodeById(id);
        return node == null ? null : new ContentBlock(this.part, node);
    }

    public final ContentBlock addBlock(float x, float y, String blockType, MimeType mimeType, String data) {
        this.checkNotClosed();
        String id = NativeFunctions.addBlock(this.nativeRef, x, y, blockType, mimeType.ordinal(), data);
        ContentNode node = this.contentTree.getNodeById(id);
        return node == null ? null : new ContentBlock(this.part, node);
    }

    public final ContentBlock addImage(float x, float y, File inputFile, MimeType mimeType) throws NullPointerException, IllegalArgumentException, IOException {
        this.checkNotClosed();
        if (inputFile == null) {
            throw new NullPointerException("Input file required");
        }
        if (mimeType == null) {
            throw new NullPointerException("Mime type required");
        }
        if (!mimeType.isImage()) {
            throw new IllegalArgumentException("Needs image input format");
        }
        String id = NativeFunctions.addImage(this.nativeRef, x, y, inputFile.getAbsolutePath(), mimeType.ordinal());
        ContentNode node = this.contentTree.getNodeById(id);
        return node == null ? null : new ContentBlock(this.part, node);
    }

    public final void removeBlock(ContentBlock block) {
        this.checkNotClosed();
        NativeFunctions.removeBlock(this.nativeRef, block.getId());
    }

    public final ContentBlock hitBlock(float x, float y) {
        this.checkNotClosed();
        String id = NativeFunctions.hitBlock(this.nativeRef, x, y);
        ContentNode node = this.contentTree.getNodeById(id);
        return node == null ? null : new ContentBlock(this.part, node);
    }

    public final ConversionState[] getSupportedTargetConversionStates(ContentBlock block) {
        this.checkNotClosed();
        int[] ordinals = NativeFunctions.getSupportedTargetConversionStates(this.nativeRef, block == null ? null : block.getId());
        ConversionState[] conversionState = new ConversionState[ordinals.length];
        for (int i = 0; i < conversionState.length; ++i) {
            if (ordinals[i] == 1 << ConversionState.HANDWRITING.ordinal()) {
                conversionState[i] = ConversionState.HANDWRITING;
                continue;
            }
            if (ordinals[i] == 1 << ConversionState.DIGITAL_PUBLISH.ordinal()) {
                conversionState[i] = ConversionState.DIGITAL_PUBLISH;
                continue;
            }
            if (ordinals[i] != 1 << ConversionState.DIGITAL_EDIT.ordinal()) continue;
            conversionState[i] = ConversionState.DIGITAL_EDIT;
        }
        return conversionState;
    }

    public final void convert(ContentBlock block, ConversionState targetState) {
        this.checkNotClosed();
        int targetState_ = 0;
        switch (targetState) {
            case HANDWRITING: {
                targetState_ = 1 << ConversionState.HANDWRITING.ordinal();
                break;
            }
            case DIGITAL_PUBLISH: {
                targetState_ = 1 << ConversionState.DIGITAL_PUBLISH.ordinal();
                break;
            }
            case DIGITAL_EDIT: {
                targetState_ = 1 << ConversionState.DIGITAL_EDIT.ordinal();
            }
        }
        NativeFunctions.convert(this.nativeRef, block == null ? null : block.getId(), targetState_);
    }

    public final MimeType[] getSupportedExportMimeTypes(ContentBlock block) {
        this.checkNotClosed();
        int[] ordinals = NativeFunctions.getSupportedExportMimeTypes(this.nativeRef, block == null ? null : block.getId());
        MimeType[] mimeTypes = new MimeType[ordinals.length];
        for (int i = 0; i < mimeTypes.length; ++i) {
            mimeTypes[i] = MimeType.values()[ordinals[i]];
        }
        return mimeTypes;
    }

    public final String export_(ContentBlock block, MimeType mimeType) throws NullPointerException, IllegalArgumentException, IllegalStateException, UnsupportedOperationException, IOException {
        this.checkNotClosed();
        if (mimeType == null) {
            throw new NullPointerException("Mime type required");
        }
        if (!mimeType.isTextual()) {
            throw new IllegalArgumentException("Needs textual output format");
        }
        return NativeFunctions.doExport1(this.nativeRef, block == null ? null : block.getId(), mimeType.ordinal(), 0L);
    }

    public final void export_(ContentBlock block, OutputStream outputStream, MimeType mimeType, IImageDrawer imageDrawer) throws NullPointerException, IllegalStateException, UnsupportedOperationException, IOException {
        this.export_(block, outputStream, mimeType, imageDrawer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void export_(ContentBlock block, OutputStream outputStream, MimeType mimeType, IImageDrawer imageDrawer, ParameterSet overrideConfiguration) throws NullPointerException, IllegalStateException, UnsupportedOperationException, IOException {
        this.checkNotClosed();
        if (outputStream == null) {
            throw new NullPointerException("Output stream required");
        }
        if (mimeType == null) {
            throw new NullPointerException("Mime type required");
        }
        if (mimeType.isTextual()) {
            String outputString = NativeFunctions.doExport1(this.nativeRef, block == null ? null : block.getId(), mimeType.ordinal(), overrideConfiguration == null ? 0L : overrideConfiguration.nativeRef);
            try (OutputStreamWriter out = new OutputStreamWriter(outputStream, "UTF-8");){
                out.write(outputString);
                out.flush();
            }
        } else {
            WritableByteChannel outputChannel = Channels.newChannel(outputStream);
            NativeFunctions.doExport3(this.nativeRef, block == null ? null : block.getId(), outputChannel, mimeType.ordinal(), imageDrawer, overrideConfiguration == null ? 0L : overrideConfiguration.nativeRef);
        }
    }

    @Deprecated
    public final void export_(ContentBlock block, File outputFile, IImageDrawer imageDrawer) throws NullPointerException, IllegalArgumentException, IllegalStateException, UnsupportedOperationException, IOException {
        this.checkNotClosed();
        if (outputFile == null) {
            throw new NullPointerException("Output file required");
        }
        NativeFunctions.doExport2(this.nativeRef, block == null ? null : block.getId(), outputFile.getAbsolutePath(), -1, imageDrawer, 0L);
    }

    @Deprecated
    public final void export_(ContentBlock block, File outputFile, MimeType mimeType, IImageDrawer imageDrawer) throws NullPointerException, IllegalStateException, UnsupportedOperationException, IOException {
        if (outputFile == null) {
            throw new NullPointerException("Output file required");
        }
        if (mimeType == null) {
            throw new NullPointerException("Mime type required");
        }
        NativeFunctions.doExport2(this.nativeRef, block == null ? null : block.getId(), outputFile.getAbsolutePath(), mimeType.ordinal(), imageDrawer, 0L);
    }

    public final void export_(ContentBlock block, String outputFileName, IImageDrawer imageDrawer) throws NullPointerException, IllegalArgumentException, IllegalStateException, UnsupportedOperationException, IOException {
        this.checkNotClosed();
        if (outputFileName == null) {
            throw new NullPointerException("Output file name required");
        }
        NativeFunctions.doExport2(this.nativeRef, block == null ? null : block.getId(), outputFileName, -1, imageDrawer, 0L);
    }

    public final void export_(ContentBlock block, String outputFileName, MimeType mimeType, IImageDrawer imageDrawer) throws NullPointerException, IllegalStateException, UnsupportedOperationException, IOException {
        this.checkNotClosed();
        if (outputFileName == null) {
            throw new NullPointerException("Output file name required");
        }
        if (mimeType == null) {
            throw new NullPointerException("Mime type required");
        }
        NativeFunctions.doExport2(this.nativeRef, block == null ? null : block.getId(), outputFileName, mimeType.ordinal(), imageDrawer, 0L);
    }

    public final String export_(ContentBlock block, MimeType mimeType, ParameterSet overrideConfiguration) throws NullPointerException, IllegalArgumentException, IllegalStateException, UnsupportedOperationException, IOException {
        this.checkNotClosed();
        if (mimeType == null) {
            throw new NullPointerException("Mime type required");
        }
        if (!mimeType.isTextual()) {
            throw new IllegalArgumentException("Needs textual output format");
        }
        return NativeFunctions.doExport1(this.nativeRef, block == null ? null : block.getId(), mimeType.ordinal(), overrideConfiguration == null ? 0L : overrideConfiguration.nativeRef);
    }

    public final void export_(ContentBlock block, String outputFileName, IImageDrawer imageDrawer, ParameterSet overrideConfiguration) throws NullPointerException, IllegalArgumentException, IOException {
        this.checkNotClosed();
        if (outputFileName == null) {
            throw new NullPointerException("Output file name required");
        }
        NativeFunctions.doExport2(this.nativeRef, block == null ? null : block.getId(), outputFileName, -1, imageDrawer, overrideConfiguration == null ? 0L : overrideConfiguration.nativeRef);
    }

    public final void export_(ContentBlock block, String outputFileName, MimeType mimeType, IImageDrawer imageDrawer, ParameterSet overrideConfiguration) throws NullPointerException, IllegalStateException, UnsupportedOperationException, IOException {
        this.checkNotClosed();
        if (outputFileName == null) {
            throw new NullPointerException("Output file name required");
        }
        if (mimeType == null) {
            throw new NullPointerException("Mime type required");
        }
        NativeFunctions.doExport2(this.nativeRef, block == null ? null : block.getId(), outputFileName, mimeType.ordinal(), imageDrawer, overrideConfiguration == null ? 0L : overrideConfiguration.nativeRef);
    }

    public final MimeType[] getSupportedImportMimeTypes(ContentBlock block) {
        this.checkNotClosed();
        int[] ordinals = NativeFunctions.getSupportedImportMimeTypes(this.nativeRef, block == null ? null : block.getId());
        MimeType[] mimeTypes = new MimeType[ordinals.length];
        for (int i = 0; i < mimeTypes.length; ++i) {
            mimeTypes[i] = MimeType.values()[ordinals[i]];
        }
        return mimeTypes;
    }

    public final void import_(MimeType mimeType, String data, ContentBlock block) throws IllegalStateException {
        this.checkNotClosed();
        NativeFunctions.doImport(this.nativeRef, mimeType.ordinal(), data, block == null ? null : block.getId());
    }

    public final void copy(ContentBlock block) throws IllegalStateException {
        this.checkNotClosed();
        NativeFunctions.copy(this.nativeRef, block == null ? null : block.getId());
    }

    public final void paste(float x, float y) throws IllegalStateException {
        this.checkNotClosed();
        NativeFunctions.paste(this.nativeRef, x, y);
    }

    public final boolean isIdle() {
        this.checkNotClosed();
        return NativeFunctions.isIdle(this.nativeRef);
    }

    public final void waitForIdle() {
        this.checkNotClosed();
        NativeFunctions.waitForIdle(this.nativeRef);
    }

    public final boolean isScrollAllowed() {
        this.checkNotClosed();
        return NativeFunctions.isScrollAllowed(this.nativeRef);
    }

    public final Configuration getConfiguration() {
        this.checkNotClosed();
        return this.configuration;
    }
}

