/*
 * Decompiled with CFR 0.152.
 */
package com.myscript.iink;

import com.myscript.iink.ContentPackage;
import com.myscript.iink.NativeFunctions;
import com.myscript.iink.ParameterSet;
import com.myscript.iink.graphics.Rectangle;
import com.myscript.util.IAutoCloseable;

public class ContentPart
implements IAutoCloseable {
    ContentPackage parent;
    long nativeRef;

    ContentPart(ContentPackage parent, long nativeRef) {
        this.parent = parent;
        this.nativeRef = nativeRef;
    }

    @Override
    public final void close() {
        if (this.nativeRef != 0L) {
            NativeFunctions.destroyPart(this.nativeRef);
            this.nativeRef = 0L;
        }
    }

    public final boolean isClosed() {
        return this.nativeRef == 0L;
    }

    final void checkNotClosed() {
        if (this.nativeRef == 0L) {
            throw new IllegalStateException(this.getClass().getName() + " closed");
        }
    }

    public final ContentPackage getPackage() {
        return this.parent;
    }

    public final String getId() {
        this.checkNotClosed();
        return NativeFunctions.getPartId(this.nativeRef);
    }

    public final String getType() {
        this.checkNotClosed();
        return NativeFunctions.getPartType(this.nativeRef);
    }

    public Rectangle getViewBox() {
        this.checkNotClosed();
        return NativeFunctions.getPartViewBox(this.nativeRef);
    }

    public final ParameterSet getMetadata() {
        this.checkNotClosed();
        return new ParameterSet(NativeFunctions.getPartMetadata(this.nativeRef));
    }

    public final void setMetadata(ParameterSet parameters) {
        this.checkNotClosed();
        parameters.checkNotClosed();
        NativeFunctions.setPartMetadata(this.nativeRef, parameters.nativeRef);
    }
}

